#include "draw_library.h"
#include "gears.h"
#include "font_100.h"
#include "font_50.h"
#include "font_24.h"

extern LCD_DISCO_F469NI lcd;
extern Serial pc;


void DrawTpsBar(void)
{
    lcd.DrawRect(350,10,440,100);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    for(int x=350; x<790; x+=11)
    {
        lcd.DrawRect(x,10,11,100);
    }
    lcd.SetTextColor(LCD_COLOR_BLACK);  
}


void DrawBrakeBar(void)
{
    lcd.DrawRect(350,370,440,100);;
    lcd.SetTextColor(LCD_COLOR_RED);
    for(int x=350; x<790; x+=9)
    {
        lcd.DrawRect(x,370,9,100);
    }
}

void UpdateTpsBar(uint16_t tpsValue)
{
    uint16_t barXPos = 350;
    uint16_t barYPos = 10;
    uint16_t barHeight = 11;
    uint16_t barWidth = 100;
    // tps range from 12 to 95
    uint8_t tpsRange = tpsValue-12;
    //uint8_t tpsRange0 = tpsValue0-12;
    // 2 tps range = 1 tps bar
    uint8_t tpsNumberBar = tpsRange/2;
    //uint8_t tpsNumberBar0 = tpsRange0/2;
    
    
    if(tpsValue<=12)
    {
        lcd.SetTextColor(LCD_COLOR_BLUE);
        for(int i=barXPos; i<790; i+=barHeight)
        {
            lcd.DrawRect(barXPos,barYPos,barHeight,barWidth);
        }
        lcd.SetTextColor(LCD_COLOR_BLACK);
    }
    else if(tpsValue>=94)
    {
        lcd.SetTextColor(LCD_COLOR_BLUE);
        for(int i=0; i<40; ++i)
        {
            lcd.FillRect(barXPos, barYPos, barHeight, barWidth);
            barXPos += barHeight;
        }
        lcd.SetTextColor(LCD_COLOR_BLACK);
    }
    else
    {
        lcd.SetTextColor(LCD_COLOR_BLUE);
        for(int i=0; i<tpsNumberBar; ++i)
        {
            lcd.FillRect(barXPos, barYPos, barHeight, barWidth);
            barXPos += barHeight;
        }
        lcd.SetTextColor(LCD_COLOR_BLACK);   
    }
}



void UpdateBrakeBar(uint16_t brakeValue)
{
    uint16_t barXPos = 350;
    uint16_t barYPos = 370;
    uint16_t barHeight = 9;
    uint16_t barWidth = 100;
    // 2 brake value = 1 brake bar
    uint8_t brakeNumberBar = brakeValue/2;
    //uint8_t tpsNumberBar0 = tpsRange0/2;
    
    
    if(brakeValue<=0)
    {
        lcd.SetTextColor(LCD_COLOR_RED);
        for(int i=barXPos; i<790; i+=barHeight)
        {
            lcd.DrawRect(barXPos,barYPos,barHeight,barWidth);
        }
        lcd.SetTextColor(LCD_COLOR_BLACK);
    }
    else if(brakeValue>=100)
    {
        lcd.SetTextColor(LCD_COLOR_RED);
        for(int i=0; i<49; ++i)
        {
            lcd.FillRect(barXPos, barYPos, barHeight, barWidth);
            barXPos += barHeight;
        }
        lcd.SetTextColor(LCD_COLOR_BLACK);
    }
    else
    {
        lcd.SetTextColor(LCD_COLOR_RED);
        for(int i=0; i<brakeNumberBar; ++i)
        {
            lcd.FillRect(barXPos, barYPos, barHeight, barWidth);
            barXPos += barHeight;
        }
        lcd.SetTextColor(LCD_COLOR_BLACK);   
    }
}


void ChangeCommand(void)
{                           
    change_flag = 1;                              // Enable Interrupt flag
}


void ChangeScreen(void)
{
    switch(screen_flag)
    {
        case(2):
            screen_flag = 1;                      // Change flag to new value (current screen)
            SetMain();                            // Set Main Screne.
            break;
        case(1):
            screen_flag = 2;                      // Change flag to new value (current screen)
            SetAux();                             // Set Aux Screne.
            break;
    }
    change_flag=0;                                // Disable Interrupt flag
}


void PrintChar_24(CHAR Char, uint16_t StartXPos, uint16_t StartYPos, uint32_t TextColor)
{
    uint16_t width=Char.width;
    uint16_t height=Char.height;
    uint16_t horpos,vertpos;
    uint16_t bitloc;
    uint32_t DrawColor;
    uint16_t x,y;
    
    // pos[0-7] = string(uint8_t), pos[8] = '\0'
    char pos[9];                            
    int bitMapPos = 0;
    
    for(vertpos=0; vertpos<height; ++vertpos)
    {   
        // We divide by 8 because we plot uint8_t.                             
        for(horpos=0; horpos<width/8; ++horpos)        
        {
            // sprintf - Instead of printing on console, it store output on char buffer which are specified in sprintf.
            // Convert uint8_t from hex to binary. 1 to fill, 0 to skip.
            sprintf(pos,BYTE_TO_BINARY_PATTERN,BYTE_TO_BINARY(Char.bitmap[bitMapPos])); 
            ++bitMapPos;  
            //pc.printf("%d. %s\n",horpos*height/8+vertpos,pos);
            for(bitloc=0;bitloc<8;bitloc++) 
            {
                if (pos[bitloc]=='1') 
                {
                    DrawColor=TextColor;
                }
                else
                {
                    DrawColor=lcd.GetBackColor();
                }
                
                x = StartXPos-vertpos;
                y = StartYPos+horpos*8+bitloc;
                
                
                lcd.DrawPixel(x, y, DrawColor);
                //pc.printf("%d,%d\n",StartXPos+horpos,StartYPos+vertpos*8+bitloc);                   
            }
        }
    }
    lcd.SetTextColor(LCD_COLOR_WHITE);
}







void PrintChar(CHAR Char, uint16_t StartXPos, uint16_t StartYPos, uint32_t TextColor)
{
    uint16_t width=Char.width;
    uint16_t height=Char.height;
    uint16_t horpos,vertpos;
    uint16_t bitloc;
    uint32_t DrawColor;
    uint16_t x,y;
    
    // pos[0-7] = string(uint8_t), pos[8] = '\0'
    char pos[9];                            
    int bitMapPos = 0;
    
    for(horpos=0; horpos<width; ++horpos)
    {   
        // We divide by 8 because we plot uint8_t.                             
        for(vertpos=0; vertpos<height/8; ++vertpos)        
        {
            // sprintf - Instead of printing on console, it store output on char buffer which are specified in sprintf.
            // Convert uint8_t from hex to binary. 1 to fill, 0 to skip.
            sprintf(pos,BYTE_TO_BINARY_PATTERN,BYTE_TO_BINARY(Char.bitmap[bitMapPos])); 
            ++bitMapPos;  
            //pc.printf("%d. %s\n",horpos*height/8+vertpos,pos);
            for(bitloc=0;bitloc<8;bitloc++) 
            {
                if (pos[bitloc]=='1') 
                {
                    DrawColor=TextColor;
                }
                else
                {
                    DrawColor=lcd.GetBackColor();
                }
                
                x = StartXPos-vertpos*8-bitloc;
                y = StartYPos+horpos;
                
                lcd.DrawPixel(x, y, DrawColor);
                //pc.printf("%d,%d\n",StartXPos+horpos,StartYPos+vertpos*8+bitloc);                   
            }
        }
    }
    lcd.SetTextColor(LCD_COLOR_WHITE);
}







void PrintString(char str[], uint8_t font, uint16_t StartXPos, uint16_t StartYPos, uint32_t TextColor)
{
    char *a=str;
    int p=0;
    switch(font)
    {
        case 24:
            while(a[p])
            {
                for(int i=0; i<62; ++i)
                {
                    if((*font24[i]).name==a[p])
                    {
                        PrintChar_24(*font24[i], StartXPos, StartYPos, TextColor);
                        StartYPos += (*font24[i]).width;
                        break;
                    }    
                }
                p++;
            }
            break;
                
        case 50:
            while(a[p])
            {
                for(int i=0; i<69; ++i)
                {
                    if((*font50[i]).name==a[p])
                    {
                        PrintChar(*font50[i], StartXPos, StartYPos, TextColor);
                        StartYPos += (*font50[i]).width;
                        break;
                    }    
                }
                p++;
            }
            break;        
    }
}






void SetNumber(int num,int Font,uint16_t StartXPos,uint16_t StartYPos, int digits, int dec_point, int sign)
{
    int digit[3],sum=0,aux=0;
    CHAR **font;
    
    if (Font==50)
    {
        font=font50;
    }
    else if (Font==100)
    {
        font=font100;
    }
    
    lcd.SetTextColor(LCD_COLOR_BLACK);
    uint8_t char_width=(*font[0]).width;
    
    if(num<pow(float(10),digits))
    {
        digit[0]=abs(num)/pow((float)10,(float)(digits-1));
        for(int i=1; i<digits; ++i)
        {
            sum=(sum+digit[i-1])*10;
            digit[i]=abs(num)/pow((float)10,(float)(digits-1-i))-sum;
        }
        
        if(sign==1)
        {
            if(num<0)                           // Print minus if number lower than 0
            {                                                          
                PrintChar(*font[10],StartXPos,StartYPos,lcd.GetTextColor());
            }
            else if(num>=0)                     // Print blank if number lower than 0
            {                                                    
                lcd.SetTextColor(LCD_COLOR_WHITE);
                lcd.FillRect(StartXPos, StartYPos, (*font[10]).width, (*font[10]).height);
                lcd.SetTextColor(LCD_COLOR_BLACK);
            }
            aux+=(*font[10]).width;
        }
              
        for(int i=0; i<digits; ++i)
        { 
            if(dec_point==i & dec_point>0)       // Default is for font50. This is not an universal solution, but it is in use because all font 100 infos are integers
            {  
                PrintChar(CharDot_50, StartXPos, StartYPos+dec_point*char_width, LCD_COLOR_BLACK);
                aux+=CharDot_50.width;
            }
            
            PrintChar(*font[digit[i]], StartXPos, StartYPos+i*char_width+aux, LCD_COLOR_BLACK);
        }
    }  
} 







//Function only changes the decimals that change. If number changes from 146 to 147, it only changes 6 to 7.
void ChangeNumber(int num, int num0, uint8_t Font, uint16_t StartXPos, uint16_t StartYPos, int digits, int dec_point, int sign)
{
    int digit[digits];
    int digit0[digits];
    int sum=0,sum0=0,aux=0;
    CHAR **font;
    if(abs(num)<pow(float(10),digits))
    {
        digit[0]=abs(num)/pow((float)10,(float)(digits-1));
        digit0[0]=abs(num0)/pow((float)10,(float)(digits-1));
        for(int i=1; i<digits; ++i)
        {
            sum=(sum+digit[i-1])*10;
            digit[i]=abs(num)/pow((float)10, (float)(digits-1-i))-sum;
            sum0=(sum0+digit0[i-1])*10;
            digit0[i]=abs(num0)/pow((float)10, (float)(digits-1-i))-sum0;
        }
        
        if(Font==50)
        {
            font = font50;
        }
        else if(Font==100)
        {
            font = font100;
        }
        
        lcd.SetTextColor(LCD_COLOR_BLACK);
        uint8_t char_width=(*font[0]).width;
        
        if(sign==1)
        {
            if(num<0 & num0>=0)                 // Print minus if number lower than 0
            {
                PrintChar(*font[10], StartXPos, StartYPos, LCD_COLOR_BLACK);
            }
            else if(num>=0 & num0<0)            // Print blank if number lower than 0
            {
                lcd.SetTextColor(LCD_COLOR_WHITE);
                lcd.FillRect(StartXPos, StartYPos, (*font[10]).width, (*font[10]).height);
                lcd.SetTextColor(LCD_COLOR_BLACK);
            }
            aux+=(*font[10]).width;
        }
        
        for(int i=0; i<digits; ++i)
        {
            if(dec_point==i & dec_point>0)
            {
               PrintChar(CharDot_50, StartXPos, StartYPos+dec_point*char_width, LCD_COLOR_BLACK); 
               aux+=CharDot_50.width;
            }
            if(digit[i]!=digit0[i])
            {
                PrintChar(*font[digit[i]], StartXPos, StartYPos+i*char_width+aux, LCD_COLOR_BLACK);
            }
        }
    }    
}






void SetMain(void)
{
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(0, 0, 800, 480);
    lcd.SetTextColor(LCD_COLOR_BLACK);

/************************************** Tps position **************************/
    DrawTpsBar();
    SetNumber(tpsValue,50,tpsXPos,tpsYPos,3,0,0);
    PrintString("TPS", 24, 345, 120, LCD_COLOR_BLACK);
/******************************************************************************/


    
/*************************************** Brake position ***********************/
    DrawBrakeBar();
    SetNumber(brakeValue,50,brakeXPos,brakeYPos,3,0,0);
    PrintString("BRAKE", 24, 345, 280, LCD_COLOR_BLACK);
/******************************************************************************/



/*************************************** Gear position ************************/     
    PrintChar(Gear1, gearXVPos, gearYVPos, LCD_COLOR_BLACK);
/******************************************************************************/



/*************************************** Oil Temp position ********************/    
    SetNumber(oilTempValue,100,oilTempXPos,oilTempYPos,3,0,0);
    PrintString("Oil Temp", 24, 170, 50, LCD_COLOR_BLACK);
/******************************************************************************/



/*************************************** Water Temp position ******************/    
    SetNumber(waterTempValue,100,waterTempXPos,waterTempYPos,3,0,0);
    PrintString("Water Temp", 24, 170, 290, LCD_COLOR_BLACK);
/******************************************************************************/
    
    
    
/*************************************** Speed position ***********************/    
    SetNumber(speedValue,100,speedXPos,speedYPos,3,0,0);
    PrintString("km", 50, 125, 320, LCD_COLOR_BLACK);
    PrintString("h", 50, 65, 345, LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DrawVLine(70,315,100);
    lcd.DrawVLine(71,315,100);
/******************************************************************************/

    ChangeNumber(78, waterTempValue, 100, waterTempXPos, waterTempYPos, 3, 0, 0);
    ChangeNumber(23, tpsValue, 50, tpsXPos, tpsYPos, 3, 0, 0);
    ChangeNumber(67, brakeValue, 50, brakeXPos, brakeYPos, 3, 0, 0);
    UpdateTpsBar(23);
    UpdateBrakeBar(67);
}


void SetAux(void)
{
    
}