#include "EEPROM_DISCO_F469NI.h"
#include "draw_library.h"
#include "mbed.h"
#include "CANlibrary.h"

LCD_DISCO_F469NI lcd;                                   // Initialization LCD Display
Serial pc(USBTX, USBRX, 115200);                        // Initialization Serial. This is used only while debuging code
InterruptIn change_screen_input(D0);                    // Initialization Digital input for Change screen button
CAN can(PB_5, PB_13);                                   // Initialization CAN, RX - PB_5  TX - PB_13

uint8_t change_flag = 0;
uint8_t screen_flag = 0x01;                             // Current screen flag. 1=Main Screen, 2=Aux Screen 

uint16_t gearValue0 = 0;
uint16_t brakeValue0 = 0;
uint16_t speedValue0 = 0;
uint16_t waterTempValue0 = 0;
uint16_t oilTempValue0 = 0;
uint16_t tpsValue0 = 0;

uint16_t gearValue = 0;
uint16_t brakeValue = 0;
uint16_t speedValue = 0;
uint16_t waterTempValue = 0;
uint16_t oilTempValue = 0;
uint16_t tpsValue = 0;


int main()
{ 
    can.frequency(100000);                              // Set CAN Frequency
    can_initRX();                                       // Initialization RX CAN
    change_screen_input.rise(&ChangeCommand);           // Attach interrupt function to rising edge of DigitalIn for changing screen.
    SetMain();                                          // First screen is main by default
    while(1)
    {
        if(change_flag)                                 // Check if screen is changed           
        {                       
            ChangeScreen();                         
        }
        UpdateInfo();                           // Update info for DTA values in every iteration
//        switch(screen_flag){                    // Display only changes visible on current screen
//            case(1):
//                MainUpdate();
//                break;
//            case(2):
//                AuxUpdate();
//                break;
//        }    
    }
}





























