/*
 * BreathLed.h
 *
 *  Created on: 2015/4/6
 *      Author: steeven@gmail.com
 */

#ifndef SCOPE_H_
#define SCOPE_H_

#include "mbed.h"
#include "BufferedSerial/BufferedSerial.h"

#define SCOPE_PINS 16

namespace steeven {

/** A simple Oscilloscope that log each pin's data change
 * Please dump log and analyze using excel x-y chart type!
 */

typedef struct {
    char id; //bit 7: val, bit 0-6:id
    float time;
} ScopeData;

class Scope {
public:
    Scope(int buf_len);

    void add(PinName pin, const char *name);

    void log(char id, int v);

    void dump(  BufferedSerial *logger);

protected:
    const char *_names[SCOPE_PINS];
    int _cnt;

    Timer _timer;

    ScopeData *_buf;
    int _buf_len;
    int _buf_cnt;
};

class ScopePin {

public:
    ScopePin(PinName pin, char id, Scope *scope);

protected:
    void on_fall();
    void on_rise();

    InterruptIn _pin;
    char _id;
    Scope *_scope;
};

}
;

#endif
