#include "Scope.h"

namespace steeven {

ScopePin::ScopePin(PinName pin, char id, Scope *scope) :
        _pin(pin), _id(id), _scope(scope) {
    _pin.fall(this, &ScopePin::on_fall);
    _pin.rise(this, &ScopePin::on_rise);
}

void ScopePin::on_fall() {
    _scope->log(_id, 0);
}
void ScopePin::on_rise() {
    _scope->log(_id, 1);
}

Scope::Scope(int buf_len) :
        _buf_len(buf_len) {
    _cnt = 0;
    _buf_cnt = 0;
    _buf = new ScopeData[buf_len];
    _timer.start();
}

void Scope::add(PinName pin, const char *name) {
    new ScopePin(pin, _cnt, this);
    _names[_cnt] = name;
//  printf("%s ", _names[_cnt]);
    _cnt++;
}

void Scope::log(char id, int v) {
    if (_buf_cnt >= _buf_len)
        error("Scope buffer overflow!\n");
    _buf[_buf_cnt].id = (char) (v << 7) + id;
    _buf[_buf_cnt].time = _timer.read();
    _buf_cnt++;
}

void Scope::dump(BufferedSerial *logger) {
    int i, j, k;

    logger->putc('\n');

    // channel names;
    logger->puts("time\t");
    for (i = 0; i < _cnt; ++i) {
        logger->puts(_names[i]);
        logger->putc('\t');
    }
    logger->putc('\n');

    // channel data
    for (j = 0; j < _cnt; ++j) { // buy channel
        for (i = 0; i < _buf_cnt; ++i) { // find in all data
            if ((_buf[i].id & 0x7f) == j) { // if this pin
                logger->printf("%f\t", _buf[i].time);
                for (k = 0; k < j; ++k)
                    logger->putc('\t');
                logger->printf("%d", ((_buf[i].id & 0x80) > 0 ? 1 : 0) + j * 2); // add offset
                logger->putc('\n');
            }
        }
    }

    //clear data
    _buf_cnt = 0;
}
}
