#include "mbed.h"
#include "BreathLed/BreathLed.h"
#include "PeripheralPins.h"

using namespace steeven;

BreathLed led1(LED1);

Serial pc(USBTX, USBRX);
Serial uart1(PA_9, PA_10);

/** NUCLEO_STM32F411RE uart hardware flow control with RTS/CTS
* 
* How to test: 
*   0. Modify serial_api.c, change flow control type from NONE to:
*         UartHandle.Init.HwFlowCtl  = UART_HWCONTROL_RTS_CTS;
*   1. Continuesly send or paste large data to USB console
*   2. Connect CTS(PA_11) pin to GND, data should sent with writable().
* No need to connect a peer uart device.
*/


int main() {
    char ch;
    int i = 0;
    int j = 0;
    led1.loop(0.5, 0.2);
    pc.baud(115200);
    PinMap rts =  {PA_12,  UART_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF7_USART1)};
    PinMap cts =  {PA_11,  UART_1, STM_PIN_DATA(STM_MODE_AF_PP, GPIO_PULLUP, GPIO_AF7_USART1)};
    pin_function(rts.pin, rts.function);
    pin_function(cts.pin, cts.function);
    pin_mode(rts.pin, PullUp); //output, uart request peer to send
    pin_mode(cts.pin, PullUp); //input, peer send 0 to allow uart send

    uart1.baud(115200);

    pc.printf("hello world!\n");
    while (1) {
        if (pc.readable()) {
            i++;
            ch = pc.getc();
            if (uart1.writeable()) {
                uart1.putc(ch);
            } else {
                pc.printf("%d/%d ", i,j); //if
            }
            if (i%50 == 49){
                pc.printf("\r\n%d lost: %d \r\n", i,i-j);
            }
        }
        if (uart1.readable()) {
            ch = uart1.getc();
            j++;
        }
    }
}

