// Do not remove the include below
#include "mbed.h"
#include "EpdGDE021A1.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "BreathLed.h"


/*
 * E-ink EPD module: GDE021A1 Built-in controller: SSD1606
 *  http://www.good-display.cn/products_detail/&productId=158.html
 *
 * Connection:
 * Mega128RFA1  LPC1678
 *  NC
 *  3V3         Vout
 *  5V
 *  GND         GND
 *  GND
 *  P2
 *
 *  NC
 *  BS1             //SPI 4-line or 3 line(9bits)
 *  BUSY            //busy
 *  nRES        P10 //reset
 *  nD/C        P9  //data/cmd
 *  nCS         P8  //SPI cs
 *  SCLK        P7  //SPI clock
 *  SDA         P5  //SPI MOSI
 *
 * Warning:
 *  SPI-0 is used, can't use the spare p6(miso) for other usage!
 * SPI 3-wire:
 *   Disconnect BS1 or pull-high, disconnect nD/C
 *   don't pass "dc" in class constructor
 *   Didn't work for me
 *
 */

steeven::BreathLed led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
AnalogIn adc5(p20);
AnalogIn adc4(p19);

Serial pc(USBTX, USBRX);

EpdGDE021A1 epd(p5, p7, p8, p9, p10);

int main() {
    int i = 0, j, h = 10, offset;

    led1.loop();

    pc.printf("clear\n");
//  epd.g.clear();
    for (i = 3; i >=0; i--) {
        epd.color(i,3);
        offset = (h + 2) * 3;
        epd.rect(offset * 0 + (h + 2) * i, 1, offset * 0 + (h + 2) * i + h,
                1 + h);
        epd.fillrect(offset * 1 + (h + 2) * i, 1,
                offset * 1 + (h + 2) * i + h, 1 + h);
        epd.circle(offset * 2 + (h + 2) * i + h / 2, h / 2 + 1, h / 2);
        epd.fillcircle(offset * 3 + (h + 2) * i + h / 2, h / 2 + 1, h / 2);
        epd.line(80, 42+i, 170, 33 + i * 10);
    }

    epd.locate(0, h + 2);
    epd.font(Arial24x23);
    epd.print("Hello world\n");
    epd.font(Arial12x12);
    epd.print("Please input:\n> ");
    epd.update();

    while (1) {
        j = 0;
        led4 = !led4;
        wait(0.5);
        while (pc.readable()) {
            epd.putc(pc.getc());
            j++;
        }
        if (j){
            epd.print("\n> ");
            epd.update();
        }
    }
}

