#ifndef EPDGDE021A1_H_
#define EPDGDE021A1_H_

#include "mbed.h"
#include "Graphic.h"

#define GED021A1_BUF_SIZE 3096
#define GED021A1_WIDH 172
#define GED021A1_HIGHT 72
#define GED021A1_BITS 2

class EpdGDE021A1: public Graphic {

public:
    EpdGDE021A1(PinName mosi = p5, PinName sclk = p7, PinName cs = p8,
            PinName dc = p9, PinName reset = p10);

    void setup();
    void update();
    void sleep();

public:
    virtual ~EpdGDE021A1() {
    }

protected:
    void draw(unsigned char *data);
    void reset();
    void wait_busy();
    void write_lut();
    void init();
    void spi_write(int cmd, unsigned char val);
    void spi_cmd(unsigned char cmd);
    void spi_data(unsigned char val);
    SPI _spi;
    DigitalOut _spi_ncs;
    DigitalOut _spi_ndc;
    DigitalOut _reset;
    int _spi3w;

public:
    unsigned char _buf[GED021A1_BUF_SIZE];
};

#endif /* EPDGDE021A1_H_ */
