/*
 * BreathLed.h
 *
 *  Created on: 2015/4/6
 *      Author: steeven@gmail.com
 */

#ifndef BREATHLED_H_
#define BREATHLED_H_

#include "mbed.h"

#define BREATH_STEPS 24

namespace steeven {

/** A breath led, used for turn on/off or loop the leds slowly with PWM.
 */
class BreathLed {

public:
    /**
     * Create an BreathLed
     *
     * @param pin LED pin with PWM support
     * @param time Time for the brightness transition
     * @param hold Time for holding the brightness before next transition.
     *      Effective for loop mode.
     */
    BreathLed(PinName pin, float time = 1, float hold = 1);

    virtual ~BreathLed();

    /* Group: Access Methods */

    /**
     * start loop the led
     */
    void loop(float time = 1, float hold = 1);

    /**
     * turn on the led
     */
    void on();

    /**
     * turn off the led
     */
    void off();


protected:
    PwmOut _pin;
    int _mode; //loop, on, off
    float _time; //time of brightness transition
    float _hold; //time to hold in loop
    Ticker _ticker;

    int _off; //current direction
    int _step; //current brightness

    void step_tick();
    void hold_tick();
};
}
#endif /* BREATHLED_H_ */
