#include "mbed.h"
#include "BreathLed.h"

using namespace steeven;

BreathLed leds[] = { BreathLed(LED1), BreathLed(LED2), BreathLed(LED3),
        BreathLed(LED4) };
const int n = sizeof(leds) / sizeof(leds[0]);
Serial pc(USBTX, USBRX);

/*
 * Demo the BreahLed usage
 * Press 0/1/2 on console to loop/on/off the leds
 */
int main() {
    int i;
    for (i = 0; i < n; ++i) {
        leds[i].loop((i + 0.5) / 2, 0.3);
    }
    pc.printf("Press 0/1/2 to loop/on/off the leds\n");
    while (1) {
        switch (pc.getc()) {
        case '0':
            for (i = 0; i < n; ++i) {
                leds[i].loop(i + 0.5, 0.5);
            }
            pc.printf("loop...");
            break;
        case '1':
            for (i = 0; i < n; ++i) {
                leds[i].on();
            }
            pc.printf("on...");
            break;
        case '2':
            for (i = 0; i < n; ++i) {
                leds[i].off();
            }
            pc.printf("off...");
            break;
        default:
            break;
        }
    }
}
//  Auto Added by "SMeshLink SMeshStudio"

