#ifndef _HANDLE_GPS_H_
#define _HANDLE_GPS_H_

#include "adapt/usb.h"
#include "adapt/gps.h"

#include <mbed.h>
#include <string>
#include <sstream>

#include "packet.h"
#include "dataLocation.h"
#include "gps.h"

#define MAXREADIN 256

typedef struct _Point{
    double lat;
    double lon;
} Point;

class GPSHandle{
private:
    //GPS gps;
    bool initialized;
    
    /// \brief Setup
    void setup();
    /// \brief Check if it is time to update
    bool check();
public:
    /// \brief Constructor
    GPSHandle():initialized(false){}
    
    void sendGpsCommand(std::string command);
    
    void next_waypoint();
    
    //handle incoming com from GPS hardware
    void handleUpdate();
    
    /// \brief Run an instance of this
    void run();
    
    /// \brief sends the current location
    void sendLoc();
    
    /// \brief checks if in image area
    bool if_image_location();
    
    /// \brief read in the waypoints
    char readWaypoints();
    
    static GPSHandle* hand;
    static GPSHandle& getGPSHand(){
        if(hand == NULL){
            hand = new GPSHandle();
        }
        return *hand;
    }
};

#endif