#ifndef _HANDLECOMPASS_H_
#define _HANDLECOMPASS_H_

#include "adapt/compass.h"
#include "adapt/usb.h"

class compassHandle {
public:
    /**
    * \brief the last read compass heading
    **/
    float heading;
    
    /**
    * \brief constructor for the compass handle.  Sets up the compass for reading.
    **/
    compassHandle();
    
    /**
    * \brief sets up the compass for reading headings
    **/
    void setup();
    
    /**
    * \brief gets an updated heading
    **/
    void run();
    
    static compassHandle* hand;
    static compassHandle& getCompassHand(){
        if(hand == NULL){
            hand = new compassHandle();
        }
        return *hand;
    }
    
private:
    /**
    * \brief reference to the compass adaptor
    **/
    Compass compass;
    
    bool initialized;
};

#endif