#ifndef _TAKEIMAGE_H_
#define _TAKEIMAGE_H_

#include "adapt/usb.h"
#include "adapt/xbee.h"
#include "adapt/camera.h"
#include "packet.h"
#include <algorithm>
#include "dataLocation.h"
class ImageHandle{
private:
    Camera cam;
    bool initialized;
    Serial& outputDevice;
    
    /// \brief Setup the camera.
    void setup();
    /// \brief Take an image and send it over USB
    void take();
    /// \brief Check if an image must be taken
    bool check();

public:

    /// \brief Constructor
    ImageHandle():initialized(false),outputDevice(USB::getSerial()){}
    /// \brief Run an instance of this
    void run();
    
    static ImageHandle* hand;
    static ImageHandle& getImageHand(){
        if(hand == NULL){
            hand = new ImageHandle();
        }
        return *hand;
    }
};

#endif