/**
  *  \brief Camera interface
  **/
#define CAMERABUFFSIZ 128
#include "usb.h"
#include "mbed.h"

/// Define Pinout
#define CAMERAPINTX p13
#define CAMERAPINRX p14

/// Define Baud
#define CAMERABAUD 38400

/// Define commands
#define VC0706_RESET  0x26
#define VC0706_GEN_VERSION 0x11
#define VC0706_READ_FBUF 0x32
#define VC0706_GET_FBUF_LEN 0x34
#define VC0706_FBUF_CTRL 0x36
#define VC0706_DOWNSIZE_CTRL 0x54
#define VC0706_DOWNSIZE_STATUS 0x55
#define VC0706_READ_DATA 0x30
#define VC0706_WRITE_DATA 0x31
#define VC0706_COMM_MOTION_CTRL 0x37
#define VC0706_COMM_MOTION_STATUS 0x38
#define VC0706_COMM_MOTION_DETECTED 0x39
#define VC0706_MOTION_CTRL 0x42
#define VC0706_MOTION_STATUS 0x43
#define VC0706_TVOUT_CTRL 0x44
#define VC0706_OSD_ADD_CHAR 0x45

#define VC0706_STOPCURRENTFRAME 0x0
#define VC0706_STOPNEXTFRAME 0x1
#define VC0706_RESUMEFRAME 0x3
#define VC0706_STEPFRAME 0x2

#define VC0706_640x480 0x00
#define VC0706_320x240 0x11
#define VC0706_160x120 0x22

#define VC0706_MOTIONCONTROL 0x0
#define VC0706_UARTMOTION 0x01
#define VC0706_ACTIVATEMOTION 0x01

#define VC0706_SET_ZOOM 0x52
#define VC0706_GET_ZOOM 0x53

//#define CAMERABUFFSIZ 100
#define CAMERADELAY 10




/// \brief Camera class
class Camera{
    static Serial* camera;
    static uint8_t  serialNum;
    uint8_t bufferLen;
    uint8_t  camerabuff[CAMERABUFFSIZ+1];
    uint16_t frameptr;
public:
    /// \brief Call this function to get a hold of the serial for camera.
    static Serial& getSerial();
    /// \brief Reset the camera
    bool reset();
    /// \brief Get the camera version
    char * getVersion(void);
    
    bool takePicture();
    bool resumeVideo();
    bool cameraFrameBuffCtrl(uint8_t command);
    uint8_t* readPicture(uint8_t n,uint8_t* outSize=NULL);
    uint32_t frameLength(void);
    /// \brief Get the image Size
    uint8_t getImageSize();
    /// \brief Set the image Size
    bool setImageSize(uint8_t x);
    //
    // Low level commands
    //
    // Run a command
    bool runCommand(uint8_t cmd, uint8_t *args, uint8_t argn, uint8_t resplen, bool flushflag = true);
    // Output the buffer over the USB
    void printBuff();
    // Varify the response
    bool verifyResponse(uint8_t command);
    // Read the response
    uint8_t readResponse(uint8_t numbytes, uint8_t timeout);
    // Send the command
    void sendCommand(uint8_t cmd, uint8_t args[] = 0, uint8_t argn = 0);
};