#include "handleCommand.h"

CommandHandle* CommandHandle::hand = NULL;

void CommandHandle::setup(){
    initialized = false;
}

int CommandHandle::getNextPacketType(){
    PacketStruct pack;
    char rx_status = getPS().receivePacket(&pack);
    if(rx_status == 1){
        return pack.type;
    }
    return -1;
}

void CommandHandle::getCommands(){
    getPS().openConnection();
    getPS().sendPacket(0,NULL,0,PT_EMPTY);
    getPS().sendPacket(0,NULL,0,PT_GETCOMMANDS);
    getPS().clearRXBuffer();
    getPS().sendPacket(0,NULL,0,PT_END);
    char startCommandsReceived = 0;
    char endCommandsReceived = 0;
    char pack_type_failed = 0;
    char waypoints_sent = 0;
    char location_requested = 0;
    if(getPS().getSynced() == 1){
        while(!endCommandsReceived && !pack_type_failed){
            int pack_type = getNextPacketType();
            if(pack_type < 0){
                USB::getSerial().printf("Failed to get packet type!\r\n");
                pack_type_failed = 1;
            }else{
                switch(pack_type){
                    case PT_STARTCOMMANDS:
                        //USB::getSerial().printf("Start Commands\r\n");
                        startCommandsReceived = 1;
                        break;
                    case PT_ENDCOMMANDS:
                        endCommandsReceived = 1;
                        USB::getSerial().printf("End Commands\r\n");
                        break;
                    case PT_WAY:
                        GPSHandle::getGPSHand().readWaypoints();
                        break;
                    case PT_REQLOC:
                        USB::getSerial().printf("\r\n\r\nLocation Requested!!!!!!!!!!!!!!!!!!!!!!!!!!!\r\n\r\n\r\n");
                        location_requested = 1;
                        break;
                    default:
                        USB::getSerial().printf("Unknown command issued: %d\r\n",pack_type);
                        break;
                }
            }
        }
    }else{
        USB::getSerial().printf("Failed to sync!!!!!\r\n");   
    }
    USB::getSerial().printf("Done Getting Commands. Closing Connection.\r\n");
    getPS().closeConnection();
    //if(location_requested){
        USB::getSerial().printf("sending location...\r\n");
        GPSHandle::getGPSHand().sendLoc();
    //}
}

void CommandHandle::locationRequest(){
    
}

bool CommandHandle::check(){
    return true;
}

void CommandHandle::run(){
    if(!initialized){
        initialized=true;
        USB::getSerial().printf("Setup Command Handler\r\n");
        setup();
    }
    if(check()){
        USB::getSerial().printf("Getting Commands\r\n");
        getCommands();
        USB::getSerial().printf("Done Getting Commans\r\n");
    }
}