#include "dataLocation.h"

DataLocation* LocHolder::get(LHType type){
    if(type==LHType_locs){
        return locs;
    }else if(type==LHType_targ){
        return targ;
    }else if(type==LHType_base){
        return base;
    }
    return base;
}

unsigned int LocHolder::getRealIndex(LHType type,int index,int offset,bool useSize){
    return (index+offset)%(useSize?getI(type,LHIType_size):MAXNUMLOCS);
}

DataLocation& LocHolder::getC(LHType type,int offset){
    return get(type)[getRealIndex(type,offset)];
}

unsigned int& LocHolder::getI(LHType type,LHIType indexType){
    if(indexType==LHIType_head){
        // Grab proper header
        if(type==LHType_locs){return headLocs;}else if(type==LHType_targ){return headTarg;}else if(type==LHType_base){return headBase;}
    }else if(indexType==LHIType_size){
        // Grab proper size
        if(type==LHType_locs){return sizeLocs;}else if(type==LHType_targ){return sizeTarg;}else if(type==LHType_base){return sizeBase;}    
    }
    return headLocs;
}

void LocHolder::inc(LHType type,int amount,bool abs){
    // Grab current index holder
    unsigned int& index=getI(type);
    // Set index and make sure the index is valid (not negative or greater than max)
    index=getRealIndex(type,(abs?0:index)+amount);
    getI(type)=index;
}

void LocHolder::add(LHType type,DataLocation newLoc){
    // Set the current index to the current size
    //getI(type)=getI(type,LHIType_size);
    // Increment size
    unsigned int newSize=getI(type,LHIType_size)+1;
    getI(type,LHIType_size)=newSize>MAXNUMLOCS?MAXNUMLOCS:newSize;
    // Increment type using new size
    inc(type);
    // Assign current index
    getC(type,getI(type))=newLoc;
}

static LocHolder* mainLocHolder=NULL;
LocHolder& DH::Locs(){if(mainLocHolder==NULL){mainLocHolder=new LocHolder();}return *mainLocHolder;}