#include "flightControl.h"

PwmOut throttle(p21);
PwmOut roll(p22);
PwmOut pitch(p23);
//PwmOut yaw(p24);
PwmOut arm(p25);
PwmOut baroHold(p26);

//TODO see if pwm output gets initialized 
void FlightControl::startPwm(){
    throttle.period_ms(20);
    roll.period_ms(20);
    pitch.period_ms(20);
    //        yaw.period_ms(20);
    arm.period_ms(20);
}

void FlightControl::stopPwm(){
    throttle.pulsewidth_us(0);
    roll.pulsewidth_us(0);
    pitch.pulsewidth_us(0);
//        yaw.pulsewidth_us(0);
    throttle.pulsewidth_us(0);
}

//-500 means full back; 500 means full forward
void FlightControl::setPitch(int val){
    if (val > 500) val = 500;
    else if (val < -500) val = 0;
    pitch.pulsewidth_us(1500 + val);
}

//-500 means full left; 500 means full right
void FlightControl::setRoll(int val){
    if (val > 500) val = 500;
    else if (val < -500) val = 0;
    roll.pulsewidth_us(1500 + val);
}

//0 means no throttle, 1000 means full throttle
void FlightControl::setThrottle(int val){
    if (val > 1000) val = 1000;
    else if (val < 0) val = 0;
    throttle.pulsewidth_us(1000 + val);        
}

void FlightControl::setArmState(bool armState){
    if (armState) arm.pulsewidth_us(2000);
    else arm.pulsewidth_us(1000);
}

void FlightControl::setHoldAltitude(bool hold){
    if (hold) baroHold.pulsewidth_us(2000);
    else baroHold.pulsewidth_us(1000);
}