#ifndef _XBEE_H_
#define _XBEE_H_
#include "mbed.h"
#include <InterruptIn.h>


/// Define Pinout
#define XBEEPINTX p9
#define XBEEPINRX p10

/// Define Baud
#define XBEEBAUD 57600
//115200

class XBEE{
private:
    static Serial* xbee;
    static DigitalOut* setTCPConStatus;
    static DigitalIn* getTCPConStatus;
    static InterruptIn* TCPconnLost;

public:
    /// \brief Call this function to get a hold of the serial for USB.
    static Serial& getSerial();
    static DigitalOut& getTCPConOut();
    static DigitalIn& getTCPConIn();
    static InterruptIn& getTCPInterrupt();
};
#endif