#include "adapt/Timeout.h"

EvTimer::EvTimer(){
    num_trips = 0;
    s_period = 1;
    us_period = 0;
}

unsigned int EvTimer::get_num_trips(){
    return num_trips;
}

void EvTimer::set_us_period(unsigned int usec){
    us_period = usec;
    s_period = 0;
}

void EvTimer::set_s_period(float sec){
    s_period = sec;
    us_period = 0;
}

void EvTimer::timer_interrupt_handler(){
    num_trips++;
}

void EvTimer::start_timer(){
    if(s_period > 0){
        t.attach(this,&EvTimer::timer_interrupt_handler, s_period);
    }else{
        t.attach_us(this, &EvTimer::timer_interrupt_handler, us_period);
    }
}

void EvTimer::stop_timer(){
    t.detach();
}

void EvTimer::restart(){
    stop_timer();
    clear();
    start_timer();
}

void EvTimer::clear(){
    num_trips = 0;
}