
#ifndef SNTPCLIENT_H
#define SNTPCLIENT_H

#include "mbed.h"
#include "UDPSocket.h"

/** SNTPClient client Class.
 *
 * Example (ethernet network):
 * @code
 * #include "mbed.h"
 * #include "EthernetInterface.h"
 * #include "SNTPClient.h"
 *
 * EthernetInterface   eth(MOSI, MISO, SCK, CS, RESET); 
 * SNTPClient          sntp;
 *
 * int main() {
 *    
 *    eth.init(); //Use DHCP
 *    eth.connect();
 *    printf("IP Address is %s\n\r", eth.getIPAddress());
 *    // example NTPpool = "1.nl.pool.ntp.org"
 *    // get seconds UTC + 1hour, enable DST and set MCU RTC
 *    serial.printf("Seconds since 1970 = %d\r\n", sntp.getNTP("1.nl.pool.ntp.org",1,1,1));
 *    
 * }
 * @endcode
 */

class SNTPClient
{
public:
        
    SNTPClient();
        
    /** Get the NTP date and time and set RTC
    \param NTPpool  The NTP server url eg. "2.es.pool.ntp.org"
    \param tzffset  Timezone offset in hours eg. 3, will add 3 hours to UTC time
    \param dst      Double Summer Time enable (EU only) enable=1, disable=0
    \param setRTC   Set MCU RTC if successfull enable=1, disable =0
    \return the number of seconds since 1970 on success or 0 on failure
    */        
    uint32_t getNTP(char * NTPpool, uint32_t tzoffset, bool dst, uint32_t setRTC);

private:
    UDPSocket socket;
    Endpoint sntp_server;
};

#endif
