
//  Wiznet WIZ550io bytsize SNTPClient Example
//  Tested using MAX32630FTHR board

#include "mbed.h"
#include "EthernetInterface.h"
#include "SNTPClient.h"

#include "max32630fthr.h" 
    //Init board and set GPIO to 3.3V logic
MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
 
EthernetInterface   eth(P5_1, P5_2, P5_0, P3_0, P3_1); // MOSI, MISO, SCK, CS, RESET
SNTPClient          sntp;
 
int main() {
    
    printf("Initialise! \n\n");
    eth.init(); //Use DHCP
    printf("Connecting.. \n");
    eth.connect();
    printf("IP Address is: %s\n\n", eth.getIPAddress());
    printf("Get NTP... \n\n");
    
    // example NTPpool = "1.nl.pool.ntp.org"
    // get seconds UTC + 1hour, enable DST and set MCU RTC
    printf("Seconds since 1970 = %d\n\n", sntp.getNTP("1.nl.pool.ntp.org",1,1,1));
    time_t ctTime;
    ctTime = time(NULL);
    printf("RTC is set to: %s\n", ctime(&ctTime));
}
 