#include "mbed.h"
#include "NetworkInterface.h"

DigitalOut  led(LED1); // (PTA1)

NetworkInterface* net = NetworkInterface::get_default_instance();

char sendbuffer[] = "GET /data\r";

Timer t1;
 
int main() { 
    
    led=1;ThisThread::sleep_for(1000);led=0;
    printf("\033[0m\033[2J\033[H\n  ----- TCP Server Connect Test -----\n\n\n");
    printf("Mbed OS version %d.%d.%d\n\n", MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);

    printf("Initialise!\n");
    printf("Connecting to network...\n\n");
    
    // set static IP, not working on WIFI at the moment 
    //net->set_network((SocketAddress)IP,(SocketAddress)NETMASK,(SocketAddress)GATEWAY);
    
    if (!net) {
        printf("No network interface found, select an interface in 'mbed_app.json'\n");
        return NULL;
    }
    nsapi_error_t connect_status = net->connect();
    if (connect_status != NSAPI_ERROR_OK) {
        printf("Failed to connect to network (%d)\n", connect_status);
        return NULL;
    }
    SocketAddress net_addr;   
    net->get_ip_address(&net_addr);
    printf("IP address: %s\n", net_addr.get_ip_address() ? net_addr.get_ip_address() : "None");
    net->get_netmask(&net_addr);
    printf("Netmask:    %s\n", net_addr.get_ip_address() ? net_addr.get_ip_address() : "None");
    net->get_gateway(&net_addr);
    printf("Gateway:    %s\n", net_addr.get_ip_address() ? net_addr.get_ip_address() : "None");    
    printf("MAC:        %s\n", net->get_mac_address()); 
        
    while(1){ 
                 
        TCPSocket remote_device;
        SocketAddress remote_addr("192.168.1.150",80);
        remote_device.open(net);        
        
        // this has no effect
        remote_device.set_timeout(2000); 
        
        led=1;
        printf ("connecting to Server..\n");
        t1.reset();t1.start();  
        remote_device.connect(remote_addr); 
        t1.stop();
        printf ("connect time: %f\n", t1.read()); 
        led=0;
           
        int buffer_size = strlen(sendbuffer);
        remote_device.send(sendbuffer, strlen(sendbuffer));    
        
        int rec_count = 128;
        char *buffer = new char[rec_count];    
        rec_count = remote_device.recv(buffer, rec_count);
        remote_device.close();
                
        buffer[rec_count]='\0';        
        printf("Server Data: %s\ncount: %d\n\n", buffer,rec_count);   
        delete[] buffer;
        
        thread_sleep_for(1000);
    }
}
