#include "mbed.h"
#include "NTPclient.h"
#include "favicon_ico.h"

// define static IP settings
#define IP         "192.168.1.180"
#define GATEWAY    "192.168.1.1"
#define NETMASK    "255.255.255.0" 
#define PORT       80

NetworkInterface *net = NetworkInterface::get_default_instance();
NTPclient         ntp(*net);

DigitalOut led(LED1);
time_t seconds;

char requestType[16];
char request[64];

char    *sendbuffer = new char[512];    // create data send buffer space
char    recevbuffer[1024];              // create http receive buffer space

int main()
{   
    printf("\033[0m\033[2J\033[HTCP NTP client and server example\r\n\n\n"); // Tera Term clear screen
    seconds = time(NULL);     
    printf("Initial RTC time: %s\r\n", ctime(&seconds));    

    // Include to set static IP    
    int net_static = net->set_network((SocketAddress)IP,(SocketAddress)NETMASK,(SocketAddress)GATEWAY);
    
    printf("Connecting to network...\n\n");

    if (!net) {
        printf("No network interface found, select an interface in 'mbed_app.json'\n");
        return NULL;
    }
    nsapi_error_t connect_status = net->connect();
    if (connect_status != NSAPI_ERROR_OK) {
        printf("Failed to connect to network (%d)\n", connect_status);
        return NULL;
    }   
    
    SocketAddress net_addr;   
    net->get_ip_address(&net_addr);
    printf("IP address: %s\n", net_addr.get_ip_address() ? net_addr.get_ip_address() : "None");
    net->get_netmask(&net_addr);
    printf("Netmask:    %s\n", net_addr.get_ip_address() ? net_addr.get_ip_address() : "None");
    net->get_gateway(&net_addr);
    printf("Gateway:    %s\n", net_addr.get_ip_address() ? net_addr.get_ip_address() : "None");    
    printf("MAC:        %s\n", net->get_mac_address());  

    net->get_ip_address(&net_addr);
    const char *ip = net_addr.get_ip_address();    
  
    if(ip){ 
        printf("\nConnected\n\nGet NTP time...\n");
        if(ntp.getNTP("0.pool.ntp.org",3600,1,1)){
            seconds = time(NULL);
            printf("RTC time set by NTP: %s\n\n", ctime(&seconds));
            }
            else{printf("No NTP could not set RTC !!\n\n");
            }  
    }else{
        printf("No IP!!\n");
        while(1);
    }         
 
    TCPSocket srv;
    TCPSocket *client_sock;  // srv.accept() will return pointer to socket
    SocketAddress client_addr;
   
    // Open the server on ethernet stack
    srv.open(net);
    // Bind the HTTP port (TCP 80) to the server    
    srv.bind(80);       
    //Can handle x simultaneous connections
    srv.listen(5); 
    
    printf("The Server IP address: '%s'\n", ip);
    printf("Waiting for connection....\r\n\n"); 
     
    nsapi_size_or_error_t result; 
        
    while(1){
                           
        client_sock = srv.accept();  //return pointer of a client socket 
        led=1; 
            //this will fill address of client to the SocketAddress object
        client_sock->getpeername(&client_addr);
        printf("\nConnected,Client: %s Port: %d\n", client_addr.get_ip_address(), client_addr.get_port()); 
            //receive client data, (set large enough buffer)
        result = client_sock->recv(recevbuffer, 1024);        
        if (result < 0) {
            printf("Error! socket.recv() returned: %d\n", result);           
        }    
        
        if(result){            
            //printf("Received Msg:\n%s\n\n", recevbuffer);     // include to view complete receive buffer
            sscanf(recevbuffer,"%s %s",requestType,request);
            printf("request: %s Type: %s  charcters:%d\n", requestType,request,result);
                   
            if(strcmp(request,"/")==0){
                //send current mcu rtc time to client
                time_t seconds = time(NULL);
                sprintf(sendbuffer,"HTTP/1.1 200 OK\n Content-type: text/plain\r\n\r\n <h1> Hello !!</h1>\r\n\n <h1>Time is: %s</h1>\r\n", ctime(&seconds));
                printf("Sending Message\n");
                result=client_sock->send(sendbuffer, strlen(sendbuffer));  // send data in buffer to http port.
                printf("Sent Message, %d bytes\n",result);
            } 
            else if(strcmp(request,"/favicon.ico")==0){
                //send favicon if requested
                printf("Sending Favicon\n"); 
                result=client_sock->send((char*)favicon_ico,sizeof(favicon_ico)); 
                printf("Sent Favicon, %d bytes\n",result);                
            }
            else{
                // send page not found reply
                sprintf(sendbuffer,"HTTP/1.1 404 Not Found\nContent-type: text/plain\r\n\r\npage not found");
                printf("Sending Not Found Message\n");
                result=client_sock->send(sendbuffer, strlen(sendbuffer));
                printf("Sent Not Found Message, %d bytes\n",result);
            }            
        }
        else{
            printf("Disconnected\n");
            }            
        //close socket       
        client_sock->close();            
        led=0;
    }
}
