#include "mbed.h"
#include "NetworkInterface.h"
#include "NTPclient.h"
#include "favicon_ico.h"

// define static IP settings
#define IP         "192.168.1.180"
#define GATEWAY    "192.168.1.1"
#define NETMASK    "255.255.255.0" 
#define PORT       80

NetworkInterface *net = NetworkInterface::get_default_instance();

TCPServer           server;
TCPSocket           client;
SocketAddress       clientAddress;

NTPclient         ntp(*net);

DigitalOut led(LED1);
time_t seconds;

char requestType[16];
char request[64];

char    *sendbuffer = new char[512];    // create data send buffer space
char    recevbuffer[1024];              // create http receive buffer space

int main()
{   
    printf("\033[0m\033[2J\033[HTCP NTP client and server example\r\n\n\n"); // Tera Term clear screen
    seconds = time(NULL);     
    printf("Initial RTC time: %s\r\n", ctime(&seconds));    

    // Include to set static IP    
    net->set_network (IP, NETMASK, GATEWAY);
     
    printf("Connecting to network...\n\n");

    nsapi_size_or_error_t r = net->connect();
    if (r != 0) {
        printf("Error! net.connect() returned: %d\n", r);
        while(1);   // stop here and find the connection problem
    }
    
    const char *ip = net->get_ip_address();
  
    if(ip){ 
        printf("\nConnected\n\nGet NTP time...\n");
        if(ntp.getNTP("0.pool.ntp.org",3600,1,1)){
            seconds = time(NULL);
            printf("RTC time set by NTP: %s\n\n", ctime(&seconds));
            }
            else{printf("No NTP could not set RTC !!\n\n");
            }  
    }else{
        printf("No IP!!\n");
        while(1);
    }         
 
    printf("Starting Server...\r\n\n");
    
    /* Open the server on ethernet stack */
    server.open(net); 
    /* Bind the HTTP port (TCP 80) to the server */
    server.bind(ip, 80); 
    /* Can handle 5 simultaneous connections */
    server.listen(5);   
    //listening for http GET request 
    printf("Ready\r\n\n");
    
    printf("The Server IP address: '%s'\n", ip);
    printf("Waiting for connection....\r\n\n"); 
    
    nsapi_size_or_error_t result; 
        
    while(1){
                           
        server.accept(&client, &clientAddress);
        
        led=1;          
        result=client.recv(recevbuffer, 1024);
        if (result < 0) {
            printf("Error! socket.recv() returned: %d\n", result);           
        }   
              
        sscanf(recevbuffer,"%s %s",requestType,request);
        printf("\nClient IP: %s \n", clientAddress.get_ip_address());                        
        //printf("Received Msg:\n%s\n\n", recevbuffer);     // include to view complete receive buffer       
        printf("request: %s Type: %s\n", requestType,request); 
       
        if(strcmp(request,"/")==0){
            //send current mcu rtc time to client
            time_t seconds = time(NULL);
            sprintf(sendbuffer,"HTTP/1.1 200 OK\n Content-type: text/plain\r\n\r\n <h1> Hello !!</h1>\r\n\n <h1>Time is: %s</h1>\r\n", ctime(&seconds));
            printf("Sending Message\n");
            result=client.send(sendbuffer, strlen(sendbuffer));  // send data in buffer to http port.
            printf("Sent Message, %d bytes\n",result);
        } 
        else if(strcmp(request,"/favicon.ico")==0){
            //send favicon if requested
            printf("Sending Favicon\n"); 
            result=client.send((char*)favicon_ico,sizeof(favicon_ico)); 
            printf("Sent Favicon, %d bytes\n",result);                
        }
        else{
            // send page not found reply
            sprintf(sendbuffer,"HTTP/1.1 404 Not Found\nContent-type: text/plain\r\n\r\npage not found");
            printf("Sending Not Found Message\n");
            result=client.send(sendbuffer, strlen(sendbuffer));
            printf("Sent Not Found Message, %d bytes\n",result);
        }                    
        //close socket       
        client.close();            
        led=0;
    }
}
