#include "mbed.h"
#include "RDA5807M.h"
#include "OLED32028P1T.h"

#if defined(TARGET_Freescale)
    #include "FreescaleIAP.h"
    //RDA5807M radio(PTC9, PTC8); // sda - scl KL25
    RDA5807M radio(PTB4, PTB3); // sda - scl KL05
    //OLED32028P1T oled(PTE0, PTE1, PTD7);  // Oled Display tx, rx, rs KL25
    OLED32028P1T oled(PTB2, PTB1, PTA11);  // Oled Display tx, rx, rs KL05
#else   
    //RDA5807M radio(p9, p10);      // sda - scl LPC1768
    RDA5807M radio(p28, p27);     // sda - scl LPC1768      
    //OLED32028P1T oled(p28, p27, p29);     // Oled Display tx, rx, rs
    OLED32028P1T oled(p13, p14, p26);     // Oled Display tx, rx, rs
    //RDA5807M radio(PC4, PC5);     // sda - scl EFM32
    //OLED32028P1T oled(PC0, PC1, PC2);     // Oled Display tx, rx, rs EFM32
#endif

Timer t1;

int x,f,v,n,i,l,r,g,b,Fl,IRQ,xbuf,ybuf,pr,prgroup;
int signal,lastsignal,volume,lastvol,lastmute,lastmono,lastbass,lastrds,laststereo,lastsynchro;
int txtlen1,txtlen2;

float lastfreq,pointer,lastpointer,Freq;
float PresetFreq[11];

char k;
char tFQ[20],freq[8],vol[4],sig[4];
char lastStationName[10];
char RDStxt[70],RDStxt1[70],RDStxt2[70],lasttext1[70],lasttext2[70],lastCT[12];
char PresetName[10][11] = {"Empty   A ", "Empty   A ", "Empty   A ", "Empty   A ", "Empty   A ", "Empty   B ", "Empty   B ", "Empty   B ", "Empty   B ", "Empty   B "};

void radiomain(),initdisplay(),displayrefresh(),getrds(),savepresets(),loadpresets();
void getkey(),flushbuffer(),Volume(),setfreq(),Power(),Preset(),Drawpresets(); 
 
int main() { 
  
    oled.init();
    oled.clear();
    oled.setTextBackgroundType (TEXT_OPAQUE);
    oled.setFontSize(FONT5X7);oled.locate(2,20);
    oled.setFontColor(oled.toRGB(255,255,255));
    oled.enableTouch();oled.resetTouchArea();   
    radio.Reset();      // reset and power up radio chip    
    
    while(1){    
        initdisplay();
        loadpresets();
        if(PresetFreq[0]!=0){radio.Frequency(PresetFreq[0]);}
        radiomain();        
    }
}

void radiomain()
{
    while(IRQ==0){
     
        getkey();   
        
    //oled.setFontSize(FONT5X7);oled.locate(20,0);  // include to calibrate touch screen buttons.
    //oled.printf("X %03d Y %03d  ",xbuf,ybuf);  
        
        if(radio.power){
            if(f){
                t1.reset();t1.start();
                setfreq();f=0;                
                }
            radio.ProcessData();
            getrds();
            if(t1.read()>5){oled.drawTextGraphic(176,16,(FONT12X16),tFQ, 1, 1, oled.toRGB(0,200,200));t1.stop();}            
            displayrefresh();        
            wait_ms(10);
        }          
    }      
}

void displayrefresh()
{   
    if (strcmp(lastStationName, radio.StationName) != 0){
        if(strlen(radio.StationName)<9){
            oled.drawTextGraphic(26,16,(FONT12X16),radio.StationName, 1, 1, oled.toRGB(0,200,200));
            strcpy(lastStationName,radio.StationName);
            }
        }    
    if(lastfreq != (radio.freq/1000) && (radio.freq/1000<108.10)){lastfreq = radio.freq/1000;
        sprintf(tFQ, "%3.2f ",radio.freq/1000);
        oled.drawTextGraphic(176,16,(FONT12X16),tFQ, 1, 1, oled.toRGB(0,200,200));       
        pointer = (lastfreq-87) *12;        
        oled.setPenSize(0);
        oled.drawRectangle(lastpointer+29,66,10,8,oled.toRGB(0,0,0));
        oled.drawRectangle(lastpointer+33,56,2,18,oled.toRGB(0,0,0));
        oled.drawRectangle(pointer+29,66,10,8,oled.toRGB(255,255,255));       
        oled.drawRectangle(pointer+33,56,2,18,oled.toRGB(255,0,0));
        oled.setPenSize(1);        
        lastpointer = pointer;
        lastsynchro=0;lastrds=!lastrds;       
        }
    if(laststereo != radio.stereo){
        if(radio.stereo){oled.drawTextGraphic(32,79,(FONT5X7),"Stereo", 1, 1, oled.toRGB(0,255,0));}
            else{oled.drawTextGraphic(32,79,(FONT5X7)," Mono ", 1, 1, oled.toRGB(255,0,0));}
        laststereo = radio.stereo;
        }        
    if(lastsignal != radio.signal){
        signal=radio.signal;
        if(radio.mute){signal=0;}
        sprintf(sig, "%d ",signal);
        oled.drawTextGraphic(124,79,(FONT5X7),sig, 1, 1, oled.toRGB(255,255,255));
        if(signal<10){r=255;g=0;b=0;}
        if(signal>9 && signal<24){r=255;g=255;b=0;}
        if(signal>15){r=0;g=255;b=0;}        
        oled.setPenSize(0);
        oled.drawRectangle(140,79,(lastsignal*2.4),6,oled.toRGB(0,0,0));
        oled.drawRectangle(140,79,(signal*2.4),6,oled.toRGB(r,g,b));
        oled.setPenSize(1);
        lastsignal=radio.signal;       
        }
    if(lastvol != radio.volume){
        volume=radio.volume;
        sprintf(vol," %d ", volume);
        oled.setPenSize(0);oled.setTextBackgroundType (TEXT_TRANSPARENT);    
        oled.drawRectangle(82,183,58,49,oled.toRGB(100,100,100));
        oled.drawTextGraphic(90,216,(FONT8X12),"Volume", 1, 1, oled.toRGB(255,255,255));  
        if(radio.volume<10){oled.drawTextGraphic(94,194,(FONT12X16),vol, 1, 1, oled.toRGB(255,255,255));} 
            else{oled.drawTextGraphic(88,194,(FONT12X16),vol, 1, 1, oled.toRGB(255,255,255));}    
        lastvol = volume;oled.setTextBackgroundType (TEXT_OPAQUE); 
        }
    if(lastmute != radio.mute){
        oled.setTextBackgroundType (TEXT_TRANSPARENT);
        if(radio.mute){oled.drawTextButton(1, 260, 197,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(128,128,128)), 1, 1, " Mute ");}
            else{oled.drawTextButton(1, 260, 197,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(255,255,255)), 1, 1, " Mute ");}
        oled.setTextBackgroundType (TEXT_OPAQUE);    
        lastmute=radio.mute;
        }
    if(lastmono != radio.mono){
        oled.setTextBackgroundType (TEXT_TRANSPARENT);
        if(radio.mono){oled.drawTextButton(1, 260, 155,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(255,0,0)), 1, 1, " Mono ");}
            else{oled.drawTextButton(1, 260, 155,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(0,255,0)), 1, 1, "Stereo");}
        oled.setTextBackgroundType (TEXT_OPAQUE);    
        lastmono=radio.mono;
        }      
    if(lastbass != radio.bass){
        oled.setTextBackgroundType (TEXT_TRANSPARENT);
        if(radio.bass){oled.drawTextButton(1, 260, 176,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(255,255,255)), 1, 1, " Bass ");}
            else{oled.drawTextButton(1, 260, 176,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(128,128,128)), 1, 1, " Bass ");}
        oled.setTextBackgroundType (TEXT_OPAQUE);    
        lastbass=radio.bass;
        }
    if(lastrds != radio.rds){
        oled.setTextBackgroundType (TEXT_TRANSPARENT);
        oled.setPenSize(0);oled.drawRectangle(0,95,320,18,oled.toRGB(0,0,0));oled.setPenSize(1);
        if(radio.rds){oled.drawTextButton(1, 260, 134,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(255,255,255)), 1, 1, " RDS  ");}
            else{oled.drawTextButton(1, 260, 134,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(128,128,128)), 1, 1, " RDS  ");lastsynchro=0;}            
        oled.setTextBackgroundType (TEXT_OPAQUE);    
        lastrds=radio.rds;
        }
    if(lastsynchro == 0 && radio.rdssynchro == 0x1000){
        oled.setTextBackgroundType (TEXT_TRANSPARENT);
        oled.drawTextButton(1, 260, 134,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(0,255,0)), 1, 1, "RDS RT");
        oled.setTextBackgroundType (TEXT_OPAQUE);
        lastsynchro=1;        
        }                              
    if (strcmp(RDStxt1, lasttext1) != 0 || strcmp(RDStxt2, lasttext2) != 0){
        oled.setPenSize(0);oled.drawRectangle(0,95,320,18,oled.toRGB(0,0,0));oled.setPenSize(1);      
        if(strlen(RDStxt1)<41){oled.drawTextGraphic(20,96,(FONT5X7),RDStxt1, 1, 1, oled.toRGB(255,255,255));}
        memset(lasttext1, '\0', sizeof(lasttext1));strcpy(lasttext1, RDStxt1);           
        if(strlen(RDStxt2)<41){oled.drawTextGraphic(20,106,(FONT5X7),RDStxt2, 1, 1, oled.toRGB(255,255,255));}
        memset(lasttext2, '\0', sizeof(lasttext2));strcpy(lasttext2, RDStxt2);  
        }           
    if(strcmp(lastCT, radio.CTtime) !=0){    
        oled.drawTextGraphic(265,120,(FONT5X7),radio.CTtime, 1, 1, oled.toRGB(255,255,255));
        strcpy(lastCT,radio.CTtime);
        }  
}       

void getrds()
{   
    if(strlen(radio.RDSText)>3){               
        memset(RDStxt1, '\0', sizeof(RDStxt1));
        memset(RDStxt2, '\0', sizeof(RDStxt2));
                                 
    // format into 2 lines of text seperated by first 'space' after 30 characters
        strcpy(RDStxt1,radio.RDSText);
        n=strlen(RDStxt1);    
        for ( i = 0; i < (n); i++ ){
            if (i>30 && (RDStxt1[i] == ' ') ){              
                RDStxt1 [strlen(RDStxt1) - (n-i)] = '\0';               
                l=strlen(RDStxt1);
                x=1;
                break; // break if more than 30 characters with space 
                }
            if(i>39){
                RDStxt1 [strlen(RDStxt1) - (n-i)] = '\0';
                l=strlen(RDStxt1);
                x=1;
                break; //break if more than 39 characters with no spaces
                }
            }
        if(x==1){           
            strcpy (RDStxt2, radio.RDSText + l);
            while(RDStxt2[0]==' '){
                strcpy (RDStxt2, (RDStxt2 + 1));
            }
            x=0;
        }
    }   
}

void initdisplay()
{    
    oled.setPenSize(1);
    oled.drawTextGraphic(50,6,(FONT5X7),"Station                  Frequency", 1, 1, oled.toRGB(0,200,200));
    oled.drawTextGraphic(260,16,(FONT12X16),"MHz", 1, 1, oled.toRGB(0,200,200));    
    oled.drawTextGraphic(42,35,(FONT5X7),"88  90  92  94  96  98 100 102 104 106 108", 1, 1, oled.toRGB(255,255,0));
    oled.drawTextGraphic(78,79,(FONT5X7),"Signal:", 1, 1, oled.toRGB(255,255,255));
    oled.drawRectangle(26,55,268,20,oled.toRGB(255,255,255));
    oled.drawRectangle(26,75,268,14,oled.toRGB(255,255,255));        
    for (i = 46; i < (300); i=i+24 )
        {oled.drawLine(i,55,i,45,oled.toRGB(255,255,255));
         oled.drawLine(i-12,55,i-12,50,oled.toRGB(255,255,255));
        }
    oled.drawTextGraphic(10,120,(FONT5X7),"Direct Tune       Seek           Preset", 1, 1, oled.toRGB(0,128,128));                   
    oled.setTextBackgroundType (TEXT_TRANSPARENT);    
    oled.drawTextButton(1, 10, 210,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, " 0 ");
    oled.drawTextButton(1, 56, 210,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, ".");   
    oled.drawTextButton(1, 10, 184,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "1");
    oled.drawTextButton(1, 33, 184,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "2");
    oled.drawTextButton(1, 56, 184,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "3");
    oled.drawTextButton(1, 10, 158,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "4");    
    oled.drawTextButton(1, 33, 158,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "5");
    oled.drawTextButton(1, 56, 158,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "6");
    oled.drawTextButton(1, 10, 132,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "7");
    oled.drawTextButton(1, 33, 132,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "8");
    oled.drawTextButton(1, 56, 132,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "9");    
    oled.drawTextButton(1, 82, 132,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "   Up   ");
    oled.drawTextButton(1, 82, 158,(oled.toRGB(0,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "  Down  ");    
    oled.drawTextButton(1, 146, 184,(oled.toRGB(100,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "+ ");
    oled.drawTextButton(1, 146, 210,(oled.toRGB(100,100,100)),(FONT12X16),(oled.toRGB(255,255,255)), 1, 1, "- ");    
    oled.drawTextButton(1, 260, 134,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(255,255,255)), 1, 1, " RDS  ");
    oled.drawTextButton(1, 260, 155,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(0,255,0)), 1, 1, "Stereo");
    oled.drawTextButton(1, 260, 176,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(128,128,128)), 1, 1, " Bass ");
    oled.drawTextButton(1, 260, 197,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(255,255,255)), 1, 1, " Mute ");
    oled.drawTextButton(1, 260, 218,(oled.toRGB(0,100,100)),(FONT8X12),(oled.toRGB(255,255,255)), 1, 1, "Power ");
     
    oled.drawTextButton(1, 190, 132,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(255,255,255)), 1, 1, "Presets  B"); 
    oled.drawTextButton(1, 190, 154,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(128,128,128)), 1, 1, PresetName[0]);
    oled.drawTextButton(1, 190, 171,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(128,128,128)), 1, 1, PresetName[1]);
    oled.drawTextButton(1, 190, 188,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(128,128,128)), 1, 1, PresetName[2]);
    oled.drawTextButton(1, 190, 205,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(128,128,128)), 1, 1, PresetName[3]);
    oled.drawTextButton(1, 190, 222,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(128,128,128)), 1, 1, PresetName[4]);   
    oled.setTextBackgroundType (TEXT_OPAQUE);   
}

void getkey()
{
    flushbuffer();
    oled.getTouch(&xbuf,&ybuf);
    if(radio.power){
        if((xbuf>12 && xbuf<32) && (ybuf>188 && ybuf<210))  {k='1';f=1;}
        if((xbuf>34 && xbuf<52) && (ybuf>188 && ybuf<210))  {k='2';f=1;}
        if((xbuf>56 && xbuf<74) && (ybuf>188 && ybuf<210))  {k='3';f=1;}
        if((xbuf>12 && xbuf<32) && (ybuf>162 && ybuf<184))  {k='4';f=1;}
        if((xbuf>34 && xbuf<52) && (ybuf>162 && ybuf<184))  {k='5';f=1;}
        if((xbuf>56 && xbuf<74) && (ybuf>162 && ybuf<184))  {k='6';f=1;}
        if((xbuf>12 && xbuf<32) && (ybuf>138 && ybuf<160))  {k='7';f=1;}
        if((xbuf>34 && xbuf<52) && (ybuf>138 && ybuf<160))  {k='8';f=1;}
        if((xbuf>56 && xbuf<74) && (ybuf>138 && ybuf<160))  {k='9';f=1;}
        if((xbuf>12 && xbuf<54) && (ybuf>212 && ybuf<232))  {k='0';f=1;}
        if((xbuf>56 && xbuf<74) && (ybuf>212 && ybuf<232))  {k='.';f=1;}
        if((xbuf>248 && xbuf<296) && (ybuf>200 && ybuf<218)){radio.Mute();}
        if((xbuf>248 && xbuf<296) && (ybuf>182 && ybuf<198)){radio.BassBoost();}
        if((xbuf>248 && xbuf<296) && (ybuf>160 && ybuf<180)){radio.Mono();}
        if((xbuf>248 && xbuf<296) && (ybuf>140 && ybuf<158)){radio.RDS();}    
        if((xbuf>140 && xbuf<170) && (ybuf>188 && ybuf<208)){v=1;Volume();}
        if((xbuf>140 && xbuf<170) && (ybuf>212 && ybuf<230)){v=0;Volume();}
        if((xbuf>80 && xbuf<176) && (ybuf>138 && ybuf<160)){radio.SeekUp();}
        if((xbuf>80 && xbuf<176) && (ybuf>162 && ybuf<184)){radio.SeekDown();}
        
        if((xbuf>182 && xbuf<244) && (ybuf>136 && ybuf<156)){
            oled.setTextBackgroundType (TEXT_TRANSPARENT);
            if(prgroup==0){prgroup=5;oled.drawTextButton(1, 190, 132,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(255,255,255)), 1, 1, "Presets  A");}
                else{prgroup=0;oled.drawTextButton(1, 190, 132,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(255,255,255)), 1, 1, "Presets  B");}
            oled.setTextBackgroundType (TEXT_OPAQUE);
            Drawpresets(); 
            }
        if((xbuf>182 && xbuf<244) && (ybuf>160 && ybuf<172)){pr=0;Preset();}
        if((xbuf>182 && xbuf<244) && (ybuf>174 && ybuf<188)){pr=1;Preset();}
        if((xbuf>182 && xbuf<244) && (ybuf>190 && ybuf<204)){pr=2;Preset();}
        if((xbuf>182 && xbuf<244) && (ybuf>206 && ybuf<220)){pr=3;Preset();} 
        if((xbuf>182 && xbuf<244) && (ybuf>224 && ybuf<234)){pr=4;Preset();} 
    }
    if((xbuf>252 && xbuf<304) && (ybuf>220 && ybuf<236)){Power();}           
}

void Preset()
{    
    if(PresetFreq[pr+prgroup]!=0 && PresetFreq[pr+prgroup]==radio.freq/1000){
        strcpy(PresetName[pr+prgroup],"Empty   ");
        if(prgroup){strcat(PresetName[pr+prgroup],"B ");}
            else{strcat(PresetName[pr+prgroup],"A ");}
        PresetFreq[pr+prgroup]=0;
        Drawpresets();
        savepresets();
        return;
        }    
    if(PresetFreq[pr+prgroup]==0){
        if(radio.signal>20 || radio.rdssynchro == 0x1000){
            strcpy(PresetName[pr+prgroup],radio.StationName);}
            else{
                sprintf(tFQ, "%3.2f MHz",radio.freq/1000);
                strcpy(PresetName[pr+prgroup],tFQ);
                }
        while(strlen(PresetName[pr+prgroup])<10){
            strcat(PresetName[pr+prgroup]," ");            
            }                      
        PresetFreq[pr+prgroup]=radio.freq/1000;
        Drawpresets();
        savepresets();
        return;
        }    
    radio.Frequency(PresetFreq[pr+prgroup]);    
}

void savepresets()
{
#if defined(TARGET_Freescale)
    int address = flash_size() - SECTOR_SIZE;           //Write in last sector    
    erase_sector(address);    
    program_flash(address, (char*)&PresetFreq, 44);        //10 integers of 4 bytes each: 40 bytes length
    program_flash(address+44, (char*)&PresetName, 440);
#endif    
}

void loadpresets()
{    
#if defined(TARGET_Freescale)
    int address = flash_size() - SECTOR_SIZE;    
    int *check = (int*)address;
    float *datafreq = (float*)address;   
    if (check[0] != -1){    
        for (i = 0; i<11; i++) {                  
            PresetFreq[i] = (datafreq[i]);            
            }            
        char *dataname = (char*)address+44;           
        memcpy (PresetName, dataname, 440);                
    }
    Drawpresets();
#endif    
}    

void Drawpresets()
{
    oled.setTextBackgroundType (TEXT_TRANSPARENT); 
    if(PresetFreq[0+prgroup]!=0){oled.drawTextButton(1, 190, 154,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(0,255,255)), 1, 1, PresetName[0+prgroup]);}
        else{oled.drawTextButton(1, 190, 154,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(128,128,128)), 1, 1, PresetName[0+prgroup]);}    
    if(PresetFreq[1+prgroup]!=0){oled.drawTextButton(1, 190, 171,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(0,255,255)), 1, 1, PresetName[1+prgroup]);}
        else{oled.drawTextButton(1, 190, 171,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(128,128,128)), 1, 1, PresetName[1+prgroup]);}       
    if(PresetFreq[2+prgroup]!=0){oled.drawTextButton(1, 190, 188,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(0,255,255)), 1, 1, PresetName[2+prgroup]);}
        else{oled.drawTextButton(1, 190, 188,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(128,128,128)), 1, 1, PresetName[2+prgroup]);}   
    if(PresetFreq[3+prgroup]!=0){oled.drawTextButton(1, 190, 205,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(0,255,255)), 1, 1, PresetName[3+prgroup]);}
        else{oled.drawTextButton(1, 190, 205,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(128,128,128)), 1, 1, PresetName[3+prgroup]);}   
    if(PresetFreq[4+prgroup]!=0){oled.drawTextButton(1, 190, 222,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(0,255,255)), 1, 1, PresetName[4+prgroup]);}
        else{oled.drawTextButton(1, 190, 222,(oled.toRGB(0,100,100)),(FONT5X7),(oled.toRGB(128,128,128)), 1, 1, PresetName[4+prgroup]);}   
    oled.setTextBackgroundType (TEXT_OPAQUE); 
}    

void setfreq()
{    
    Fl = strlen(freq); 
    if(Fl< 6){freq[Fl] = k;}    
    if (freq[0]!='1' && freq[0]!='8' && freq[0]!='9'){
        freq[0]='\0';}
    oled.setPenSize(0);oled.drawRectangle(176,16,80,14,oled.toRGB(0,0,0));oled.setPenSize(1);
    oled.drawTextGraphic(176,16,(FONT12X16),freq, 1, 1, oled.toRGB(0,200,200));
    if (freq[0]=='8' || freq[0]=='9'){Fl=5;}
        else{Fl=6;} 
    if(strlen(freq)==Fl){
        Freq = strtof (freq, NULL);
        if(Freq>86.99 && Freq<108.01){
            radio.Frequency(Freq);
            }
            else{lastfreq=0;}
        memset(freq, '\0', sizeof(freq));
    }       
}    

void Volume()
{
    if(v){volume++;}
    if(!v){volume--;}    
    if(volume > 15){volume = 15;}
    if(volume < 0){volume = 0;}  
    radio.Volume(volume);    
}

void Power()
{
    if(radio.power){      
        radio.RDS();
        radio.ProcessData();
        displayrefresh();
        radio.PowerOff();
        radio.ProcessData();
        displayrefresh();
    }    
    else{    
        radio.PowerOn();
        radio.RDS();
        radio.Frequency(lastfreq);
        radio.ProcessData();    
    }   
}

void flushbuffer()
{
    while (xbuf!=0 && ybuf!=0){oled.getTouch(&xbuf,&ybuf);}
}
            

          
    
    
    
    
    

 

