//      I2C - Search for devices on an I2C bus,

//  Continuously cycles through each device address, checking for a response
//  Prints 8-bit address for each device found and possible devices that use that address
//  if bus isn't working check pull-up resistors are fitted, typicaly 4k7 on SDA and CLK
//  Recommend to use TeraTerm VT serial monitor at 9600 baud 



#include "mbed.h"

//I2C i2c(p28, p27);    // sda, clk     LPC1768
//I2C i2c(p9, p10);     // sda, clk     LPC1768

// I2C i2c(PB_11, PB_10);// sda, clk     STM F746      

//I2C i2c(PB_7, PB_6);  // sda, clk     STM L432
//I2C i2c(PA_10, PA_9); // sda, clk     STM L432
//I2C i2c(PB_4, PA_7);  // sda, clk     STM L432

I2C i2c(D14, D15);      // sda, clk     STM 64 nucleo boards ARDUINO PINS
//I2C i2c(A4, A5);      // sda, clk     STM 64 nucleo boards L476


/*
#include "max32630fthr.h" 
    //Init board and set GPIO to 3.3V logic
MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
I2C i2c(P3_4, P3_5);    // sda, clk
I2C i2c(P5_7, P6_0);    // sda, clk
*/
/*
#include "max32625pico.h"
//MAX32625PICO pico(MAX32625PICO::IOH_DIP_IN, MAX32625PICO::VIO_IOH, MAX32625PICO::VIO_1V8);
MAX32625PICO pico(MAX32625PICO::IOH_3V3, MAX32625PICO::VIO_IOH, MAX32625PICO::VIO_1V8);
Serial  pc(P0_1, P0_0); // use serial to USB converter
I2C i2c(P1_6, P1_7);    // sda, clk
*/

Serial              pc(USBTX, USBRX);
DigitalOut          led1(LED1);

//list of some i2c device possibilities
#define I2C_0x02    "PCA9955-GGG"
#define I2C_0x06    "SHT1x"
#define I2C_0x0C    "AK8975"

#define I2C_0x1C    "MAG3110"

#define I2C_0x20    "RDA5807, VEML6040, VEML6075"
#define I2C_0x22    "RDA5807"

#define I2C_0x38    "MMA8451-0, FXOS8700CQ-2"
#define I2C_0x3A    "MMA8451-1, FXOS8700CQ-1"
#define I2C_0x3C    "FXOS8700CQ-0, LIS3MDL"
#define I2C_0x3E    "FXOS8700CQ-3"

#define I2C_0x42    "MCP23017-b"
#define I2C_0x44    "MCP23017-c"
#define I2C_0x46    "MCP23017-d"

#define I2C_0x50    "MAX5387-ggg"
#define I2C_0x52    "MAX5387-ggv, VL53L0X"
#define I2C_0x54    "MAX5387-gvg"
#define I2C_0x56    "MAX5387-gvv"
#define I2C_0x58    "MAX5387-vgg"
#define I2C_0x5A    "MAX5387-vgv"
#define I2C_0x5C    "MAX5387-vvg"
#define I2C_0x5E    "MAX5387-vvv"

#define I2C_0x70    "VEML6070-ld/c"
#define I2C_0x72    "VEML6070-hd"

#define I2C_0x80    "Si7005, Si7021, HTU21D, HDC1080, INA2xx/MAX7300-gg"
#define I2C_0x82    "INA2xx/MAX7300-gv"
#define I2C_0x84    "INA2xx/MAX7300-gd"
#define I2C_0x86    "INA2xx/MAX7300-gc"
#define I2C_0x88    "INA2xx/MAX7300-vg"
#define I2C_0x8A    "INA2xx/MAX7300-vv"
#define I2C_0x8C    "INA2xx/MAX7300-vd"
#define I2C_0x8E    "INA2xx/MAX7300-vc"

#define I2C_0x90    "MCP9802, AD7416-a, LM75, INA2xx/MAX7300-dg"
#define I2C_0x92    "MAX9768, INA2xx/MAX7300-dv"
#define I2C_0x94    "INA2xx/MAX7300-dd"
#define I2C_0x96    "INA2xx/MAX7300-dc"
#define I2C_0x98    "INA2xx/MAX7300-cg"
#define I2C_0x9A    "INA2xx/MAX7300-cv"
#define I2C_0x9C    "INA2xx/MAX7300-cd"
#define I2C_0x9E    "INA2xx/MAX7300-cc"

#define I2C_0xA0    "24C32WP, 24FC512-000, 24AA02-b0"
#define I2C_0xA2    "24AA02-b1"
#define I2C_0xA4    "24AA02-b2"
#define I2C_0xA6    "24AA02-b3"
#define I2C_0xA8    "24AA02-b4"
#define I2C_0xAA    "MMA8491, 24AA02-b5, BQ27xx0, BQ34Z100-G1"
#define I2C_0xAC    "24AA02-b6, M24SR64-Y"
#define I2C_0xAE    "24AA02-b7"

#define I2C_0xB4    "CCS811-0"
#define I2C_0xB6    "CCS811-1"
#define I2C_0xBA    "LPS22HB"
#define I2C_0xBE    "HTS221"

#define I2C_0xC0    "RDA5807, MPL3115A2, MLX90620-ram, PCA9955-0"
#define I2C_0xC2    "SCD30"

#define I2C_0xD0    "M41T81, M41T11, DS1307, DS3232M, MCU9150-0"
#define I2C_0xD2    "MCU9150-1"
#define I2C_0xD4    "LSM6DSL"
#define I2C_0xDE    "MCP7941x-rtc"

#define I2C_0xE0    "PCA9955-AllCall"
#define I2C_0xEC    "MS5611-cs1, BME280-cs0, PCA9955-SubCall"
#define I2C_0xEE    "BMP-180, MS5611-cs0, BME280-cs1, BMP-05"

int n,address;
char* device;
char* getdevice();

int main() {   
   
    led1=1;wait(1);led1=0;  
    
    //i2c.frequency(50000);  // set required i2c frequency, defautl 100000 
    //  pc.baud(230400);        // set terminal speed, default 9600    
    pc.printf("\033[0m\033[2J\033[HI2C Searching!\n\n\n");    
    
    while (1) {
        
        pc.printf("\033[0m\033[2J\033[HI2C Searching!\n\n\n"); 
        
        n=0;
        pc.printf("Starting....\n\n");
        
        for (address=0; address<256; address+=2) {
            if (!i2c.write(address, NULL, 0)) { // 0 returned is ok               
                pc.printf("I2C address: 0x%02X\r\n     Device: %s\n\n", address, getdevice());
                n++;
            }
            led1=!led1;
            wait_ms(1);
        }        
        pc.printf("\n\n%d devices found\n", n); 
        wait(2);    
    }
}

char* getdevice(){
    device="Unknown";
    switch(address){        
        case 0x02:device = I2C_0x02;break;
        case 0x06:device = I2C_0x06;break;
        case 0x0C:device = I2C_0x0C;break;
        
        case 0x1C:device = I2C_0x1C;break;
        
        case 0x20:device = I2C_0x20;break;
        case 0x22:device = I2C_0x22;break;
        
        case 0x38:device = I2C_0x38;break;
        case 0x3A:device = I2C_0x3A;break;
        case 0x3C:device = I2C_0x3C;break;
        case 0x3E:device = I2C_0x3E;break;
        
        case 0x42:device = I2C_0x42;break;
        case 0x44:device = I2C_0x44;break;
        case 0x46:device = I2C_0x46;break;
            
        case 0x50:device = I2C_0x50;break;
        case 0x52:device = I2C_0x52;break;
        case 0x54:device = I2C_0x54;break;
        case 0x56:device = I2C_0x56;break;
        case 0x58:device = I2C_0x58;break;
        case 0x5A:device = I2C_0x5A;break;
        case 0x5C:device = I2C_0x5C;break;
        case 0x5E:device = I2C_0x5E;break;
        
        case 0x70:device = I2C_0x70;break;    
        case 0x72:device = I2C_0x72;break;   
    
        case 0x80:device = I2C_0x80;break;
        case 0x82:device = I2C_0x82;break;
        case 0x84:device = I2C_0x84;break;
        case 0x86:device = I2C_0x86;break;
        case 0x88:device = I2C_0x88;break;
        case 0x8A:device = I2C_0x8A;break;
        case 0x8C:device = I2C_0x8C;break;
        case 0x8E:device = I2C_0x8E;break;
   
        case 0x90:device = I2C_0x90;break;
        case 0x92:device = I2C_0x92;break;
        case 0x94:device = I2C_0x94;break;
        case 0x96:device = I2C_0x96;break;
        case 0x98:device = I2C_0x98;break;
        case 0x9A:device = I2C_0x9A;break;
        case 0x9C:device = I2C_0x9C;break;
        case 0x9E:device = I2C_0x9E;break;    
    
        case 0xA0:device = I2C_0xA0;break;
        case 0xA2:device = I2C_0xA2;break;
        case 0xA4:device = I2C_0xA4;break;
        case 0xA6:device = I2C_0xA6;break;
        case 0xA8:device = I2C_0xA8;break;
        case 0xAA:device = I2C_0xAA;break;
        case 0xAC:device = I2C_0xAC;break;
        case 0xAE:device = I2C_0xAE;break;

        case 0xB4:device = I2C_0xB4;break;
        case 0xB6:device = I2C_0xB6;break;
        case 0xBA:device = I2C_0xBA;break;
        case 0xBE:device = I2C_0xBE;break;
    
        case 0xC0:device = I2C_0xC0;break;
        case 0xC2:device = I2C_0xC2;break;
       
        case 0xD0:device = I2C_0xD0;break;
        case 0xD2:device = I2C_0xD2;break;
        case 0xD4:device = I2C_0xD4;break;
        case 0xDE:device = I2C_0xDE;break;
    
        case 0xE0:device = I2C_0xE0;break;
        case 0xEC:device = I2C_0xEC;break;
        case 0xEE:device = I2C_0xEE;break;
     }     
     return device; 
}            
