//HT1621 9 DIGIT 16SEG LCD

#include "mbed.h"
#include <stdarg.h>


     /*---Segment Display Screen----
            
          ___5___ ___13__
         | \     |     / |
        6|  7   16  15   |14
         |    \  | /     |
          ___8___ ___12__
         |     / | \     |   
        2|  3    4  11   |10
         | /     |     \ |
         -------- -------
             1       9
      
      Display code generate example: '1' = seg15 + seg14 + seg10
      
                  16 15 14 13 12 11 10  9  8  7  6  5  4  3  2  1
      Biary code = 0  1  1  0  0  0  1  0  0  0  0  0  0  0  0  0
      Hex value  = 0x6200
         
      -----------------------------
    */  
      
    //Defined HT1621's commands for this display  
    #define ComMode     0x52    // 4 comons, LCD 1/3 bias   
    #define RCosc       0x30    // on-chip RC oscillator (Power-on default) 
    #define LCD_on      0x06    // Turn on LCD bias generator       
    #define LCD_off     0x04    // Turn off LCD bias generator (default)            
    #define Sys_en      0x02    // Turn on system oscillator  
    #define Sys_dis     0x00    // Turn off system osc & LCD bias generator (default)
    
    //Other HT1621's available commands (not used)       
    #define TIMER_DIS   0x08    // Disable time base output    
    #define WDT_DIS     0x05    // Enable WDT time-out flag output
    #define TIMER_EN    0x06    // Enable time base output
    #define WDT_EN      0x07    // Enable WDT time-out flag output
    #define TONE_OFF    0x08    // Turn off tone outputs
    #define TONE_ON     0x09    // Turn on tone outputs
    #define CLR_TIMER   0xc0    // Clear the contents of time base generator
    #define CLR_WDT     0xe0    // Clear the contents of WDT stage
    #define XTAL_32K    0x14    // System clock source, crystal oscillator
    #define EXT_256K    0x1c    // System clock source, external clock source
    #define BIAS1_2_COM2  0x20    // LCD 1/2 bias option
    #define BIAS1_3_COM2  0x21    // LCD 1/3 bias option
    #define BIAS1_2_COM3  0x24    // LCD 1/2 bias option
    #define BIAS1_3_COM3  0x25    // LCD 1/3 bias option
    #define BIAS1_2_COM4  0x28    // LCD 1/2 bias option
    #define TONE_4K     0x40    // Tone frequency, 4kHz
    #define TONE_2K     0x60    // Tone frequency, 2kHz
    #define IRQ_DIS     0x80    // Disable IRQ output
    #define IRQ_EN      0x88    // Enable IRQ output
    #define F1          0xa0    // Time base/WDT clock output:1Hz The WDT time-out flag after: 4s
    #define F2          0xa1    // Time base/WDT clock output:2Hz The WDT time-out flag after: 2s
    #define F4          0xa2    // Time base/WDT clock output:4Hz The WDT time-out flag after: 1s
    #define F8          0xa3    // Time base/WDT clock output:8Hz The WDT time-out flag after: 1/2s
    #define F16         0xa4    // Time base/WDT clock output:16Hz The WDT time-out flag after: 1/4s
    #define F32         0xa5    // Time base/WDT clock output:32Hz The WDT time-out flag after: 1/8s
    #define F64         0xa6    // Time base/WDT clock output:64Hz The WDT time-out flag after: 1/16s
    #define F128        0xa7    // Time base/WDT clock output:128Hz The WDT time-out flag after: 1/32s
    #define TEST        0xe0    // Test mode, user dont use
    #define NORMAL      0xe3    // Normal mode  
        
    //ASCII character to LCD code table   
    const int num[] =  {    
    0x0000, //  space
    0x0000, //  !
    0xA000, //  "
    0x88AC, //  #
    0x1BB9, //  $
    0xCBBC, //  %
    0x85D3, //  &
    0x8000, //  '
    0x4400, //  (
    0x0044, //  )
    0xCCCC, //  *
    0x8888, //  +
    0x4000, //  '
    0x0880, //  -
    0x0000, //  .
    0x4004, //  /
    0x7337, //  0
    0x6200, //  1
    0x3993, //  2
    0x3b91, //  3
    0x2aa0, //  4
    0x1bb1, //  5
    0x1bb3, //  6
    0x3210, //  7
    0x3BB3, //  8
    0x3BB1, //  9
    0x8008, //  :
    0x8004, //  ;
    0x4480, //  <
    0x0981, //  =
    0x0844, //  >
    0x3818, //  ?
    0x3793, //  @
    0x3AB2, //  A
    0xBB19, //  B
    0x1133, //  C
    0xB319, //  D
    0x19B3, //  E
    0x18B2, //  F
    0x1B33, //  G
    0x2AA2, //  H
    0x9119, //  I
    0x2303, //  J
    0x44A2, //  K
    0x0123, //  L
    0x626A, //  M
    0x2662, //  N
    0x3333, //  O
    0x38B2, //  P
    0x3733, //  Q
    0x3CB2, //  R
    0x1BB1, //  S
    0x9018, //  T
    0x2323, //  U
    0x4026, //  V
    0xA626, //  W
    0x4444, //  X
    0x4048, //  y
    0x5115, //  Z
    0x9108, //  [
    0x0440, //  \
    0x8019, //  ]
    0x0404, //  ^
    0x0101, //  _
    0x0040, //  '
    0x0000, //  
    0x018B, //  a
    0x00AB, //  b
    0x0083, //  c
    0x808B, //  d
    0x0187, //  e
    0x9888, //  f
    0x80B9, //  g
    0x00AA, //  h
    0x0008, //  i
    0x800B, //  j
    0xC408, //  k
    0x8008, //  l
    0x0A8A, //  m
    0x008A, //  n
    0x0B83, //  o
    0x80B2, //  p
    0x80B8, //  q
    0x0082, //  r
    0x00B9, //  s
    0x8988, //  t
    0x0303, //  u
    0x0006, //  v
    0x0606, //  w
    0x4444, //  x
    0x4048, //  y
    0x0085, //  z
    0x9188, //  {
    0x9119, //  |
    0x8819, //  }
    0x1010, //  ¬   
    
}; 



/**
* 9 digit (+ Hz character) 16 segment LCD display\n
using Holeck's HT1621 LCD driver.

@code
#include "mbed.h"
#include "digitLCD.h"

digitLCD lcd(PTC0,PTC1,PTD6); // WO, CS, DATA

main()
{
    lcd.clear();            // clears display
    lcd.printf("ABCDEFGHI"); // Standard printf function, All ASCII characters will display
    
    while(1){               // basic RTC clock function
        time_t seconds = time(NULL);
        strftime(timebuf, 32, "%H-%M-%S\n", localtime(&seconds));
        strftime(datebuf, 32, "%a %d%b\n", localtime(&seconds));        
        if (n<7){lcd.printf(timebuf);}
            else{lcd.printf(datebuf);}
        if(n>10){n=0;}
        n++;
        wait(1);       
    }
@endcode
*/

class digitLCD 
{    
public:

    digitLCD(PinName Rw, PinName CS, PinName DATA); // Default constructor    
    
    //! Initialise display
    void init();
    //! Clear Display
    void clear();
    //! Powers on LCD bias generators
    void LCDon();
    //! Powers off LCD bias generators (low power mode)
    void LCDoff();
    //! LCD all segments on test
    void allsegson();
    //! Hz symbol on
    void HZon();
    //! Hz symbol off
    void HZoff();
    void SendBit(char sdata,char cnt);
    void SendCmd(int command);
    void Write(char addr,int sdata);    
    
    void putc( char line, char c ) {
        if ( (c == '\n') || (c == '\r') ) {
            clear_rest_of_line( line );
            curs[ line ] = 0;
            return;
        }        
        if (curs[ line ]  >= 9 )
            return;
        Write(curs[ line ],num[c-32]);
        curs[ line ]++;
    }
    
    void puts( char *s ) { 
         char line=0;  
        while ( char c    = *s++ )
            putc( line, c );
    }
    
    void printf(char *format, ... ) {
        char        s[ 11 ];        
        va_list        args;
        va_start( args, format );
        vsnprintf( s, 11, format, args );
        va_end( args );
        puts(  s );
        
    }
    char curs[1];
    void clear_rest_of_line( char line ) {
        for ( int i = curs[ line ]; i < 10; i++ )
            putc( line, ' ');
    }
    

private:    
    DigitalOut  _Rw;
    DigitalOut  _CS;
    DigitalOut  _DATA;   
};
