//HT1621 9 DIGIT 16SEG LCD

#include "digitLCD.h"


digitLCD::digitLCD(PinName Rw, PinName CS, PinName Data) : _Rw(Rw),_CS(CS),_DATA(Data){
    init();
}

// Initialize display 
void digitLCD::init(){
    wait_ms(10);
    SendCmd(Sys_en);
    SendCmd(RCosc);    
    SendCmd(ComMode);  
    SendCmd(LCD_on);
    allsegson();
    wait_ms(100);
    clear();
} 

// Clear Display
void digitLCD::clear(){
    char i; 
    char addr=0; 
        for(i=0;i<10;i++) 
            { 
                Write(addr,0x00); 
                addr+=1; 
            } 
}     
      
// All segments lit      
void digitLCD::allsegson(){
    char addr=0;
    char i; 
        for(i=0;i<10;i++) 
            {
                Write(addr,0xffff); 
                addr+=1; 
            } 
}

// LCDoff 
void digitLCD::LCDoff(){  
    SendCmd(LCD_off);  
}
                                
// LCDon  
void digitLCD::LCDon(){  
    SendCmd(LCD_on);  
}

// Hz symbol on
void digitLCD::HZon(){ 
    Write(9,0xFF);
}

// Hz symbol off
void digitLCD::HZoff(){ 
    Write(9,0x00); 
}

// SendBit(send data) High bit first
void digitLCD::SendBit(char sdata,char count){ 
    char i; 
       for(i=0;i<count;i++) 
            { 
              _Rw=0;
              wait_us(10); 
              if(sdata&0x80) {_DATA=1;} 
              else {_DATA=0;} 
              wait_us(10);
              _Rw=1;
              wait_us(10);
              sdata<<=1;      
            } 
        //wait_us(20);
}

// SendCmd(send cmd)Write MODEâ€œ100â€ AND 9 bits command
void digitLCD::SendCmd(int command){ 
      _CS=0; 
      SendBit(0x80,4);    
      SendBit(command,8);  
      _CS=1;                    
} 

// Write(send data and cmd) 
void digitLCD::Write(char addr,int sdata){ 
    char addr_r;       
       //addr Decoding
       switch(addr)
       {
         case 0 : addr_r = 0<<4; break;
         case 1 : addr_r = 5<<4; break;
         case 2 : addr_r = 1<<4; break;
         case 3 : addr_r = 6<<4; break;
         case 4 : addr_r = 2<<4; break;
         case 5 : addr_r = 7<<4; break;
         case 6 : addr_r = 3<<4; break;
         case 7 : addr_r = (8<<4)+0x08; break;
         case 8 : addr_r = 4<<4; break;
         default : addr_r = (9<<4)+0x08; sdata = sdata & 2;  break;
       }
       
       _CS=0; 
       SendBit(0xa0,3);         //Write MODEâ€œ101â€ 
       SendBit(addr_r,6);       //Write addr high 6 bits
       SendBit(sdata,8);        //Write data  low 8 bits
       SendBit(((sdata>>8)&0xff),8);    //Write data high 8 bits
       _CS=1; 
}   
