#include "mbed.h"
#include "SLCD.h"

time_t seconds = time(NULL); // needed to start rtc on reset to maintain reasonable time if hard reset

SLCD slcd;
Timer scroll;
DigitalOut  led1(LED1);
DigitalOut  led2(LED2);
InterruptIn setmin (SW1);
InterruptIn sethour (SW3);

struct tm t;

int i,j,k,lastscroll,display_timer,minute,hour,colon,dp;
char message[60];
void scroll_message();
char buffer[32];

void setminIRQ();
void sethourIRQ();


main()
{
    slcd.All_Segments(1);
    wait(2);
    slcd.All_Segments(0);
    wait(1);    
    
    led1 = 1;led2 = 1;
    
    sprintf(message, "    rtc clock    s3 sets the hours    s1 sets the minutes");
    
// scrolling message    
    scroll.start();
    while (i<58) {

        while (i<58) {
            scroll_message();
         }
    }
    wait(1);
    
    setmin.rise(setminIRQ);     // start set Minutes IRQ
    sethour.rise(sethourIRQ);   // start set Hours IRQ
    
// rtc clock function    
    while(1) {

        time_t seconds = time(NULL);

        if(display_timer>6) {
            strftime(buffer, 4, "%H%M", localtime(&seconds));// display Hours,Minutes for 2 seconds
            slcd.Colon(1);led2=0;
            slcd.DP2(0);led1=1;
        } else {
            strftime(buffer, 4, "%M%S", localtime(&seconds));// display Minutes,Seconds for 8 seconds            
            slcd.Colon(0);led2=1;
            slcd.DP2(1);led1=0;
        }
        slcd.printf(buffer);
        wait(.5);
        slcd.DP2(0);led1=1;
        display_timer++;
        if (display_timer>9)display_timer=0;
        wait(.5);
    }
}

void scroll_message()
{
    if (scroll.read_ms() > lastscroll + 350) {
        scroll.reset();
        if (i > 58) {
            i=0;
        }
        int j, k = i;
        for (j = 0; j < 4; j++) {
            if (message[k+j]) {
                slcd.putc(message[k+j]);
            } else {
                slcd.putc(' ');
                k--;
            }
        }
        i++;
        lastscroll=scroll.read_ms();
    }
}

void setminIRQ(void) // set Minutes ISR
{
    display_timer=7;
    time_t seconds = time(NULL);
    char buffer[2];
    strftime(buffer, 2,"%H", localtime(&seconds));
    hour = atoi(buffer);    // get Hour integer
    strftime(buffer, 2,"%M", localtime(&seconds));
    minute = atoi(buffer);  // get Minutes integer
    minute++;
    if(minute>59) minute=0;
    t.tm_sec = 0;   // Seconds reset to zero
    t.tm_min = minute;
    t.tm_hour = hour;
    t.tm_mday = 1;
    t.tm_mon = 2;
    t.tm_year = 114;
    set_time (mktime(&t));

}

void sethourIRQ(void) // set Hours ISR
{
    display_timer=7;
    time_t seconds = time(NULL);
    char buffer[2];
    strftime(buffer, 2,"%H", localtime(&seconds));
    hour = atoi(buffer);    // get Hour integer
    strftime(buffer, 2,"%M", localtime(&seconds));
    minute = atoi(buffer);  // get Minutes integer
    hour++;
    if(hour>23) hour=0;
    t.tm_sec = 0;   // Seconds reset to zero
    t.tm_min = minute;
    t.tm_hour = hour;
    t.tm_mday = 1;
    t.tm_mon = 2;
    t.tm_year = 114;
    set_time (mktime(&t));

}




