#include "mbed.h"

Serial pc(USBTX, USBRX);
Serial esp(p13,p14);    // tx,rx LPC1768
//Serial esp(D8,D2);      // tx,rx Nucleo

Timer t;

char cmdbuff[1024];
char snd[255];
int timeout;
int Baud;

char ssid[32] = "ssid";         // enter router ssid inside the quotes
char pwd [32] = "password";     // enter router password inside the quotes

void SendCMD(),getreply(),config(),restore(),getESP();
void setbaud(int espbaud);


int main() {
    
    pc.baud(115200);
    esp.baud(115200);   // Default baud is 115200, change this to match setbaud() rate.    
    
    pc.printf("\033[0m\033[2J\033[H\n  Initialize....\r\n\n\n");

    // restore();       //include to restore ESP8266 to default settings at 115200 baud.    
    // setbaud(460800); //include to set a different ESP8266 baudrate, saved in ESP8266 flash.   
    // config();        //include Config to set SSID, PASSWORD and MODE configuration saved in ESP8266 flash.
           
    strcpy(snd,"ATE0\r\n");
    SendCMD();    // set no AT ESP echo  
    timeout=5000;
    getreply();
    pc.printf(cmdbuff);
    
    pc.printf("Set Mode to station...\r\n");
    strcpy(snd, "AT+CWMODE=1\r\n");
    SendCMD();
    timeout=1000;
    getreply();
    pc.printf(cmdbuff);
    
    pc.printf("Connect to AP settings NOT stored in flash..\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "AT+CWJAP_CUR=\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\"\r\n");   
    SendCMD();
    timeout=8000;
    getreply();    
    pc.printf(cmdbuff);
    
    getESP();     
}

// contiuosly get ESP82660Firmware, AP list, IP and MAC
void getESP()
{
    while(1){
         
        pc.printf("\033[0m\033[2J\033[H ESP8266 check...\r\n\n\n");
        
        pc.printf("  Firmware Version...\r\n");
        strcpy(snd,"AT+GMR\r\n");
        SendCMD();
        timeout=5000;
        getreply();
        pc.printf(cmdbuff); 
        
        pc.printf("\n  AP's...\r\n"); 
        strcpy(snd, "AT+CWLAP\r\n");
        SendCMD();
        timeout=3000;
        getreply();   
        pc.printf(cmdbuff);

        pc.printf("  IP and MAC...\r\n"); 
        strcpy(snd, "AT+CIFSR\r\n");
        SendCMD();
        timeout=2000;
        getreply(); 
        pc.printf(cmdbuff);                
        wait_us(5000000);
    }    
}

// resturns ESP8266 back to default settings.
void restore()
{
    pc.printf("Restore ESP8266 to default...\r\n");
    t.reset();t.start();
    strcpy(snd, "AT+RESTORE\r\n");
    SendCMD();
    timeout=5000;
    getreply();
    pc.printf(cmdbuff);
    wait_us(2000000);  
    esp.baud(115200);   // set baud back to ESP8266 default         
    strcpy(snd,"ATE0\r\n");
    SendCMD();    // set no ESP echo  
    timeout=5000;
    getreply();  
    pc.printf("Remember to set esp.baud to default rate 115200\r\n");
    wait_us(5000000);  
}

// Sets new ESP8266 baurate, change the esp.baud(xxxxx) to match your new setting once this has been executed
void setbaud(int espbaud)
{
    if(espbaud!=115200 && espbaud!=230400 && espbaud!=460800 && espbaud!=921600){
        return;
        }
    pc.printf("setting ESP8266 baud to: %d\r\n",espbaud); 
    uint32_t    databits=8;
    uint32_t    stopbits=1;
    uint32_t    parity=0;
    uint32_t    flowcontrol=0;
    //  default mode     8,1,0,0
    //  <databits>:   <stopbits>:           <parity>:   <flowcontrol>:
    //  5-bit data    1=1-bit stop bit      0: None     0: flow control disabled
    //  6-bit data    2=1.5-bit stop bit    1: Odd      1: enable RTS
    //  7-bit data    3=2-bit stop bit      2: Even     2: enable CTS
    //  8-bit data                                      3: enable both RTS and CTS   
        
    sprintf(snd,"AT+UART_DEF=%d,%d,%d,%d,%d\r\n",espbaud,databits,stopbits,parity,flowcontrol);
    SendCMD(); 
    pc.printf("Remember to set esp.baud to new rate: %d\r\n",espbaud); 
    wait_us(3000000);  
    esp.baud(espbaud);   // set baud new rate    
}    

// To configure ESP8266 permanant settings in flash
void config()
{
    pc.printf("\033[0m\033[2J\033[H Starting ESP Config stored in flash\r\n\n\n");
            
    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("Set Mode...\r\n");
    strcpy(snd, "AT+CWMODE_DEF=1\r\n");
    SendCMD();
    timeout=1000;
    getreply();
    pc.printf(cmdbuff);
    
    pc.printf("Listing Acces Points...\r\n");
    strcpy(snd, "AT+CWLAP\r\n");
    SendCMD();
    timeout=3000;
    getreply();   
    pc.printf(cmdbuff); 
    
    pc.printf("Connecting to AP...\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "AT+CWJAP_DEF=\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\"\r\n");   
    SendCMD();
    timeout=8000;
    getreply();    
    pc.printf(cmdbuff);
        
    pc.printf("Get IP's...\r\n"); 
    strcpy(snd, "AT+CIFSR\r\n");
    SendCMD();
    timeout=2000;
    getreply(); 
    pc.printf(cmdbuff);
    
    pc.printf("\n\n\n  If you get a valid IP, ESP8266 has been set up.\r\n");
    wait_us(5000000);
    
    getESP();
} 

void SendCMD()
{    
    esp.printf("%s", snd);    
} 

void getreply()
{    
    uint32_t i=0;
    memset(cmdbuff, '\0', sizeof(cmdbuff));
    t.reset();t.start();
    while(t.read_ms()< timeout) {
        if(esp.readable()) {
            cmdbuff[i] = esp.getc();i++;
            }
            if (cmdbuff[i-2] == 0x4f && cmdbuff[i-1] == 0x4b){break;}
        }
    cmdbuff[i-2]=0x00;    // remove the 'OK' from message
    t.stop();
}              
 