#include "mbed.h"


// LPC1768 ESP8266 works up to 460800 baud

//Serial ports to be used
Serial pc(USBTX,USBRX);//TO BE used for debug info
Serial esp(p13,p14);//TX,RX TO BE CONNECTED TO ESP
Serial esp2(p13,p14);//TX,RX TO BE CONNECTED TO ESP
int espbaud = 115200;
DigitalOut espreset(p25,1);
//Connections to relay
//relay works at logic LOW
DigitalOut digital_out_1(LED1,1);// High on initialization
DigitalOut digital_out_2(LED2,1);// High on initialization
DigitalOut digital_out_3(LED3,1);// High on initialization
DigitalOut digital_out_4(LED4,1);// High on initialization
//digital inputs, connected to push buttons
DigitalIn digital_in_1(p21);
DigitalIn digital_in_2(p22);
DigitalIn digital_in_3(p23);
DigitalIn digital_in_4(p24);
//Analog output
PwmOut analog_out_1(p26);
//Analog Input
AnalogIn tempSensor(p20);

//F401  ESP8266 works up to 460800 baud
/*
//Serial ports to be used
Serial pc(USBTX,USBRX);//TO BE used for debug info
Serial esp(D8,D2);//TX,RX TO BE CONNECTED TO ESP
Serial esp2(D8,D2);//TX,RX TO BE CONNECTED TO ESP
int espbaud = 115200;
//Connections to relay
//relay works at logic LOW
DigitalOut digital_out_1(D3,1);// High on initialization
DigitalOut digital_out_2(D4,1);// High on initialization
DigitalOut digital_out_3(D5,1);// High on initialization
DigitalOut digital_out_4(D6,1);// High on initialization
//digital inputs, connected to push buttons
DigitalIn digital_in_1(A1);
DigitalIn digital_in_2(A2);
DigitalIn digital_in_3(A3);
DigitalIn digital_in_4(A4);
//Analog output
PwmOut analog_out_1(D15);
//Analog Input
AnalogIn tempSensor(A0);
*/

char ssid[32] = "ssid";   // enter your router ssid inside the quotes
char pwd[32] = "password"; // enter your router password inside the quotes

#define BUFFER_SIZE 3000
#define REQ_LINE_BUFF_SIZE 100
#define UNKNOWN 0
#define OK 1
#define ERROR 2
#define FAIL 3
#define READY 4
#define READY_TO_WRITE_TCP 5


const char get_analog_outputs_status[]="/analog_outputs";
const char get_Toggle_Output[]="/digital_outputs/toggle";
const char get_analog_inputs_status[]="/analog_inputs";
const char get_analog_output_update[]="/analog_outputs/update";
const char get_digital_output_status[]="/digital_outputs";
const char get_digital_inputs_html[]="/dinputs.html";
const char get_digital_input_status[]="/digital_inputs";
const char get_index_html[]="/index.html";
const char get_analog_outputs[]="/anoutputs.html";
const char get_analog_inputs_html[]="/aninputs.html";


const char jsonHeader[]="HTTP/1.1 200 OK\n"
                        "Content-type: application/json\r\n\r\n";

const char textPlainHeader[]="HTTP/1.1 200 OK\n"
                        "Content-type: text/plain\r\n\r\n";

const char index_html[]="HTTP/1.1 200 OK\n"
                        "Content-type: text/html\r\n\r\n"
                        "<!DOCTYPE html>\n<html>\n<head>\n<title>esp</title>\n<link rel=stylesheet type=text/css href=css/style.css>\n<script src=https://ajax.googleapis.com/ajax/libs/jquery/3.2.0/jquery.min.js></script>\n<script>$(document).ready(function(){setInterval(\"get_digital_output_status()\",2000)});function get_digital_output_status(){var a=\"/digital_outputs\";$.ajax({url:a,dataType:\"json\",success:function(b){if(b.digital_outputs.dout1==1){$(\"#dout1\").html(\"HIGH\")}else{$(\"#dout1\").html(\"LOW\")}if(b.digital_outputs.dout2==1){$(\"#dout2\").html(\"HIGH\")}else{$(\"#dout2\").html(\"LOW\")}if(b.digital_outputs.dout3==1){$(\"#dout3\").html(\"HIGH\")}else{$(\"#dout3\").html(\"LOW\")}if(b.digital_outputs.dout4==1){$(\"#dout4\").html(\"HIGH\")}else{$(\"#dout4\").html(\"LOW\")}},timeout:2000})}function digital_output_toggle(a){var b=\"/digital_outputs/toggle?pin=\"+a;$.ajax({url:b,dataType:\"text\",success:function(c){if(c==\"1\"){$(\"#\"+a).html(\"HIGH\")}else{if(c==\"0\"){$(\"#\"+a).html(\"LOW\")}else{alert(\"failed to toggle digital output\")}}},timeout:2000})};</script>\n</head>\n<body>\n<header>\n<img src=images/logo.jpg>\n<h1>ESP8266 BASED WEBSERVER</h1>\n</header>\n<nav>\n<ul>\n<li><a class=active href=index.html>Digital Outputs</a></li>\n<li><a href=dinputs.html>Digital inputs</a></li>\n<li><a href=anoutputs.html>Analog Outputs</a></li>\n<li><a href=aninputs.html>Analog Inputs</a></li>\n</ul>\n</nav>\n<section>\n<table>\n<tr>\n<th>Digital Ouput</th>\n<th>Status</th>\n<th>Option</th>\n</tr>\n<tr>\n<td>DOut1</td>\n<td id=dout1>waiting..</td>\n<td><button class=button onclick=\"digital_output_toggle('dout1')\">Toggle</button>\n</td>\n</tr>\n<tr>\n<td>DOut2</td>\n<td id=dout2>waiting..</td>\n<td><button class=button onclick=\"digital_output_toggle('dout2')\">Toggle</button>\n</tr>\n<tr>\n<td>DOut3</td>\n<td id=dout3>waiting..</td>\n<td><button class=button onclick=\"digital_output_toggle('dout3')\">Toggle</button>\n</tr>\n<tr>\n<td>DOut4</td>\n<td id=dout4>waiting..</td>\n<td><button class=button onclick=\"digital_output_toggle('dout4')\">Toggle</button>\n</tr>\n</table>\n</section>\n</body>\n</html>";

const char digitalInputs_html[]="HTTP/1.1 200 OK\n"
                        "Content-type: text/html\r\n\r\n"
                        "<!DOCTYPE html>\n<html>\n<head>\n<title>esp</title>\n<link rel=stylesheet type=text/css href=css/style.css>\n<script src=https://ajax.googleapis.com/ajax/libs/jquery/3.2.0/jquery.min.js></script>\n<script>$(document).ready(function(){setInterval(\"get_digital_input_status()\",2000)});function get_digital_input_status(){var a=\"/digital_inputs\";$.ajax({url:a,dataType:\"json\",success:function(b){if(b.digital_inputs.din1==1){$(\"#din1\").html(\"HIGH\")}else{$(\"#din1\").html(\"LOW\")}if(b.digital_inputs.din2==1){$(\"#din2\").html(\"HIGH\")}else{$(\"#din2\").html(\"LOW\")}if(b.digital_inputs.din3==1){$(\"#din3\").html(\"HIGH\")}else{$(\"#din3\").html(\"LOW\")}if(b.digital_inputs.din4==1){$(\"#din4\").html(\"HIGH\")}else{$(\"#din4\").html(\"LOW\")}},timeout:2000})};</script>\n</head>\n<body>\n<header>\n<img src=images/logo.jpg>\n<h1>ESP8266 BASED WEBSERVER</h1>\n</header>\n<nav>\n<ul>\n<li><a href=index.html>Digital Outputs</a></li>\n<li><a class=active href=dinputs.html>Digital inputs</a></li>\n<li><a href=anoutputs.html>Analog Outputs</a></li>\n<li><a href=aninputs.html>Analog Inputs</a></li>\n</ul>\n</nav>\n<section>\n<table id=inputsTable>\n<tr>\n<th>Digital Input</th>\n<th>Status</th>\n</tr>\n<tr>\n<td>DIn1</td>\n<td id=din1>waiting..</td>\n</td>\n</tr>\n<tr>\n<td>DIn2</td>\n<td id=din2>waiting..</td>\n</tr>\n<tr>\n<td>DIn3</td>\n<td id=din3>waiting..</td>\n</tr>\n<tr>\n<td>DIn4</td>\n<td id=din4>waiting..</td>\n</tr>\n</table>\n</section>\n</body>\n</html>";

const char analog_outputs_html[]="HTTP/1.1 200 OK\n"
                        "Content-type: text/html\r\n\r\n"
                        "<!DOCTYPE html>\n<html>\n<head>\n<title>esp</title>\n<link rel=stylesheet type=text/css href=css/style.css>\n<script src=https://ajax.googleapis.com/ajax/libs/jquery/3.2.0/jquery.min.js></script>\n<script type=text/javascript src=https://www.gstatic.com/charts/loader.js></script>\n<script>$(document).ready(function(){setInterval(\"getAnalogOutputStatus()\",2000);displayVoltageLevel()});var voltage_level=0;function getAnalogOutputStatus(){var a=\"/analog_outputs\";$.ajax({url:a,dataType:\"text\",success:function(b){voltage_level=parseFloat(b)},timeout:2000})}function setNewVoltageLevel(a){var b=\"/analog_outputs/update?value=\"+a;$.ajax({url:b,dataType:\"text\",success:function(c){voltage_level=parseFloat(c)},timeout:2000})}function displayVoltageLevel(){google.charts.load(\"current\",{packages:[\"gauge\"]});google.charts.setOnLoadCallback(a);function a(){var d=google.visualization.arrayToDataTable([[\"Label\",\"Value\"],[\"Volts\",0],]);var b={width:300,height:250,redFrom:8,redTo:12,yellowFrom:4,yellowTo:8,greenFrom:0,greenTo:4,min:0,max:12,minorTicks:5};var c=new google.visualization.Gauge(document.getElementById(\"chart_div\"));c.draw(d,b);setInterval(function(){d.setValue(0,1,voltage_level);c.draw(d,b)},500)}};</script>\n</head>\n<body>\n<header>\n<img src=images/logo.jpg>\n<h1>ESP8266 BASED WEBSERVER</h1>\n</header>\n<nav>\n<ul>\n<li><a href=index.html>Digital Outputs</a>\n</li>\n<li><a href=dinputs.html>Digital inputs</a>\n</li>\n<li><a class=active href=anoutputs.html>Analog Outputs</a>\n</li>\n<li><a href=aninputs.html>Analog Inputs</a>\n</li>\n</ul>\n</nav>\n<section>\n<h3>Enter new voltage value and press Update btton</h3>\n<input type=text id=volts maxlength=5 placeholder=Voltage..(0.00-12.00)>\n<button class=button onclick=\"setNewVoltageLevel(document.getElementById('volts').value)\">Update</button>\n<div id=chart_div style=width:300px;height:250px></div>\n<h1 style=color:blue;margin-left:50px>Voltage Level</h1>\n</section>\n</body>\n</html>";

const char analog_inputs_html[]="HTTP/1.1 200 OK\n"
                        "Content-type: text/html\r\n\r\n"
                        "<!DOCTYPE html>\n<html>\n<head>\n<title>esp</title>\n<link rel=stylesheet type=text/css href=css/style.css>\n<script src=https://ajax.googleapis.com/ajax/libs/jquery/3.2.0/jquery.min.js></script>\n<script>$(document).ready(function(){setInterval(\"getTemperature()\",2000)});function getTemperature(){var a=\"/analog_inputs\";$.ajax({url:a,dataType:\"text\",success:function(b){$(\"#temp\").html(b+\"&#8451;\")},timeout:2000})};</script>\n</head>\n<body>\n<header>\n<img src=images/logo.jpg>\n<h1>ESP8266 BASED WEBSERVER</h1>\n</header>\n<nav>\n<ul>\n<li><a href=index.html>Digital Outputs</a>\n</li>\n<li><a href=dinputs.html>Digital inputs</a>\n</li>\n<li><a href=anoutputs.html>Analog Outputs</a>\n</li>\n<li><a class=active href=aninputs.html>Analog Inputs</a>\n</li>\n</ul>\n</nav>\n<section>\n<h1 id=temp style=border-style:solid;border-width:6px;border-color:red;border-radius:20px;background-color:#aeb5b7;width:100px;margin-top:20px;margin-left:40px;padding:20px>Waiting..</h1>\n<h2 style=margin-left:25px;color:blue>Temperature Value</h2>\n<br><br><h2>Temperature history</h2>\n<iframe width=450 height=260 style=\"border:1px solid #ccc\" src=\"https://thingspeak.com/channels/243141/charts/1?bgcolor=%23ffffff&color=%23d62020&dynamic=true&results=100&type=line\"></iframe>\n</section>\n</body>\n</html>";

const char style_css[]="HTTP/1.1 200 OK\n"
                        "Content-type: text/css\r\n\r\n"
                        "*{padding:0;margin:0}header{background-color:#27ace5}body{font-family:calibri}header h1{text-align:center;font-size:4em;color:#fff;padding:10px}header img{width:110px;margin-top:10px;float:left}ul{list-style-type:none;margin:0;padding:0;overflow:hidden;background-color:#333}li{float:left}li a{display:block;color:#fff;text-align:center;padding:14px 16px;text-decoration:none}li a:hover:not(.active){background-color:#111}.active{background-color:#4CAF50}table{border-collapse:collapse;width:100%}table#inputsTable{border-collapse:collapse;width:70%}th,td{text-align:left;padding:8px}tr:nth-child(even){background-color:#f2f2f2}th{background-color:#4CAF50;color:#fff}section{width:60%;margin:10px}.button{display:inline-block;padding:10px 15px;font-size:15px;cursor:pointer;text-align:center;text-decoration:none;outline:none;color:#fff;background-color:#4CAF50;border:none;border-radius:15px;box-shadow:0 9px #999}.button:hover{background-color:#3e8e41}.button:active{background-color:#3e8e41;box-shadow:0 5px #666;transform:translateY(4px)}input[type=text],select{width:25%;padding:12px 20px;margin:8px 0;display:inline-block;border:1px solid #ccc;border-radius:4px;box-sizing:border-box}";

const char not_found_text[]="HTTP/1.1 404 Not Found\n"
                            "Content-type: text/plain\r\n\r\n"
                            "page not found";

//HTTP/1.1 200 OK
//Content-type:image/jpeg
const char logo_jpg[]={0x48, 0x54, 0x54, 0x50, 0x2F, 0x31, 0x2E, 0x31, 0x20, 0x32, 0x30, 0x30, 0x20, 0x4F, 0x4B, 0x0A, 0x43, 0x6F, 0x6E, 0x74, 0x65, 0x6E, 0x74, 0x2D, 0x74, 0x79, 0x70, 0x65, 0x3A, 0x69, 0x6D, 0x61, 0x67, 0x65, 0x2F, 0x6A, 0x70, 0x65, 0x67, 0x0D,0x0A,0x0D, 0x0A, 
                        0xFF, 0xD8, 0xFF, 0xE0, 0x00, 0x10, 0x4A, 0x46, 0x49, 0x46, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x3A, 0x43, 0x52, 0x45, 0x41, 0x54, 0x4F, 0x52, 0x3A, 0x20, 0x67, 0x64, 0x2D, 0x6A, 0x70, 0x65, 0x67, 0x20, 0x76, 0x31, 0x2E, 0x30, 0x20, 0x28, 0x75, 0x73, 0x69, 0x6E, 0x67, 0x20, 0x49, 0x4A, 0x47, 0x20, 0x4A, 0x50, 0x45, 0x47, 0x20, 0x76, 0x38, 0x30, 0x29, 0x2C, 0x20, 0x71, 0x75, 0x61, 0x6C, 0x69, 0x74, 0x79, 0x20, 0x3D, 0x20, 0x35, 0x0A, 0xFF, 0xDB, 0x00, 0x43, 0x00, 0xA0, 0x6E, 0x78, 0x8C, 0x78, 0x64, 0xA0, 0x8C, 0x82, 0x8C, 0xB4, 0xAA, 0xA0, 0xBE, 0xF0, 0xFF, 0xFF, 0xF0, 0xDC, 0xDC, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDB, 0x00, 0x43, 0x01, 0xAA, 0xB4, 0xB4, 0xF0, 0xD2, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x11, 0x08, 0x00, 0x71, 0x00, 0x96, 0x03, 0x01, 0x22, 0x00, 0x02, 0x11, 0x01, 0x03, 0x11, 0x01, 0xFF, 0xC4, 0x00, 0x1F, 0x00, 0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0xFF, 0xC4, 0x00, 0xB5, 0x10, 0x00, 0x02, 0x01, 0x03, 0x03, 0x02, 0x04, 0x03, 0x05, 0x05, 0x04, 0x04, 0x00, 0x00, 0x01, 0x7D, 0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12, 0x21, 0x31, 0x41, 0x06, 0x13, 0x51, 0x61, 0x07, 0x22, 0x71, 0x14, 0x32, 0x81, 0x91, 0xA1, 0x08, 0x23, 0x42, 0xB1, 0xC1, 0x15, 0x52, 0xD1, 0xF0, 0x24, 0x33, 0x62, 0x72, 0x82, 0x09, 0x0A, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFF, 0xC4, 0x00, 0x1F, 0x01, 0x00, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0xFF, 0xC4, 0x00, 0xB5, 0x11, 0x00, 0x02, 0x01, 0x02, 0x04, 0x04, 0x03, 0x04, 0x07, 0x05, 0x04, 0x04, 0x00, 0x01, 0x02, 0x77, 0x00, 0x01, 0x02, 0x03, 0x11, 0x04, 0x05, 0x21, 0x31, 0x06, 0x12, 0x41, 0x51, 0x07, 0x61, 0x71, 0x13, 0x22, 0x32, 0x81, 0x08, 0x14, 0x42, 0x91, 0xA1, 0xB1, 0xC1, 0x09, 0x23, 0x33, 0x52, 0xF0, 0x15, 0x62, 0x72, 0xD1, 0x0A, 0x16, 0x24, 0x34, 0xE1, 0x25, 0xF1, 0x17, 0x18, 0x19, 0x1A, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFF, 0xDA, 0x00, 0x0C, 0x03, 0x01, 0x00, 0x02, 0x11, 0x03, 0x11, 0x00, 0x3F, 0x00, 0x9A, 0x8A, 0x28, 0xA0, 0x02, 0x8A, 0x28, 0xA0, 0x02, 0x8A, 0x28, 0xA0, 0x02, 0x8A, 0x28, 0xA0, 0x02, 0x8A, 0x28, 0xA0, 0x02, 0x8A, 0x29, 0x8D, 0x20, 0x07, 0x8E, 0x68, 0x01, 0xF4, 0x50, 0x08, 0x23, 0x22, 0x8A, 0x00, 0x28, 0xA2, 0x8A, 0x00, 0x28, 0xA2, 0x8A, 0x00, 0x28, 0xA2, 0x8A, 0x00, 0x28, 0xA2, 0x8A, 0x00, 0x28, 0xA2, 0x8A, 0x00, 0x28, 0xA2, 0x8A, 0x00, 0x28, 0xA2, 0x8A, 0x00, 0x29, 0x19, 0x82, 0x8E, 0x69, 0xAC, 0xFC, 0x1D, 0xB5, 0x18, 0x04, 0xF2, 0xC7, 0x02, 0x80, 0x14, 0xB3, 0x39, 0xC0, 0xA5, 0x55, 0x03, 0xDC, 0xFE, 0x82, 0x91, 0x8E, 0xDE, 0x00, 0xE3, 0xF9, 0xD2, 0xE4, 0x10, 0x31, 0xFF, 0x00, 0x7C, 0x8A, 0x00, 0x5C, 0x9C, 0xE5, 0x7F, 0x13, 0xD8, 0xD3, 0xC1, 0x04, 0x54, 0x7D, 0xFD, 0x4F, 0xA7, 0x61, 0x40, 0xEE, 0xC0, 0xF3, 0xDF, 0xD2, 0x80, 0x25, 0xA2, 0x91, 0x58, 0x30, 0xE2, 0x96, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA6, 0x34, 0x98, 0xE1, 0x68, 0x01, 0xCC, 0xC1, 0x7A, 0xD4, 0x4E, 0xE4, 0x9C, 0x74, 0xF6, 0xA6, 0xEE, 0x39, 0xCE, 0x79, 0xA4, 0xCD, 0x30, 0x14, 0x1E, 0xC7, 0x9A, 0x56, 0xE7, 0xBE, 0x4F, 0xE9, 0x4D, 0xA5, 0x07, 0xB8, 0xE2, 0x80, 0x14, 0x1C, 0x0C, 0x1E, 0x56, 0x8E, 0x50, 0xE4, 0x72, 0x29, 0xD1, 0xE1, 0xB8, 0x27, 0xF0, 0xA5, 0x60, 0x17, 0xFD, 0xD3, 0xD4, 0x7F, 0x51, 0x48, 0x04, 0x1F, 0x32, 0xE7, 0x1C, 0x7A, 0x0F, 0xEB, 0x48, 0x48, 0x1F, 0x7B, 0xFE, 0xF9, 0x1F, 0xD6, 0x99, 0x9C, 0x1E, 0x0D, 0x25, 0x3B, 0x01, 0x22, 0xB6, 0x79, 0x1C, 0x37, 0xF3, 0xA9, 0x55, 0xB7, 0x7D, 0x7D, 0x2A, 0xBD, 0x3D, 0x4B, 0x31, 0x18, 0xEB, 0x45, 0x84, 0x4D, 0x45, 0x14, 0x52, 0x18, 0x51, 0x45, 0x14, 0x00, 0x51, 0x45, 0x14, 0x00, 0x52, 0x33, 0x05, 0x1C, 0xD2, 0xD4, 0x0E, 0x08, 0x6E, 0x68, 0x01, 0x59, 0xCB, 0x7B, 0x0A, 0x6E, 0x3A, 0x67, 0xBD, 0x07, 0x00, 0x0E, 0x0D, 0x04, 0x82, 0x29, 0x88, 0x52, 0xA0, 0x00, 0x73, 0xD7, 0xF4, 0xA6, 0xD3, 0xB2, 0x06, 0x7B, 0xFB, 0xD3, 0x4F, 0xB7, 0x4A, 0x06, 0x25, 0x2E, 0x38, 0xE7, 0x8A, 0x00, 0xFC, 0xFD, 0x69, 0x3A, 0xD2, 0x01, 0xCA, 0x07, 0x5C, 0xF4, 0xA5, 0x2D, 0xEA, 0x39, 0xF7, 0xA6, 0xD3, 0xBE, 0xF7, 0xD7, 0xDC, 0xD0, 0x03, 0x48, 0xA4, 0xA7, 0x63, 0x9C, 0x54, 0x89, 0x1E, 0x39, 0x34, 0xC4, 0x35, 0x10, 0xB7, 0xD2, 0xA5, 0x00, 0x01, 0xC5, 0x2D, 0x14, 0x86, 0x14, 0x51, 0x45, 0x00, 0x14, 0x51, 0x45, 0x00, 0x14, 0x51, 0x45, 0x00, 0x14, 0xD9, 0x00, 0x2A, 0x73, 0x4E, 0xA0, 0xF3, 0x40, 0x10, 0x12, 0x4E, 0x01, 0x3C, 0x1A, 0x1B, 0xEF, 0x64, 0x0F, 0xC2, 0x95, 0xD7, 0x61, 0xF5, 0x06, 0x9A, 0x38, 0x39, 0xCF, 0xD2, 0x80, 0x0C, 0xE4, 0xF2, 0x3A, 0x76, 0xA4, 0xEE, 0x45, 0x28, 0x04, 0xE4, 0x8E, 0xD4, 0x29, 0x18, 0x20, 0xF7, 0xA6, 0x21, 0x41, 0x04, 0x6D, 0x38, 0x03, 0xBF, 0xBD, 0x23, 0x03, 0xD7, 0x9C, 0x9E, 0x07, 0xD2, 0x92, 0x9E, 0x1B, 0x23, 0xA6, 0x5B, 0xDE, 0x80, 0x23, 0x3C, 0x53, 0x91, 0x0B, 0x1F, 0x6A, 0x91, 0x62, 0xEE, 0xD5, 0x27, 0x4A, 0x43, 0x11, 0x54, 0x2F, 0x4A, 0x5A, 0x28, 0xA0, 0x02, 0x8A, 0x28, 0xA0, 0x02, 0x8A, 0x28, 0xA0, 0x02, 0x8A, 0x28, 0xA0, 0x02, 0x8A, 0x28, 0xA0, 0x02, 0x8A, 0x28, 0xA0, 0x04, 0x23, 0x27, 0xDA, 0xA1, 0x61, 0xB7, 0x38, 0x1F, 0x2D, 0x4F, 0x48, 0x47, 0x06, 0x80, 0x21, 0x04, 0xA8, 0xE3, 0xA5, 0x36, 0x9E, 0x54, 0x83, 0xC0, 0xC8, 0x34, 0xA2, 0x3C, 0x1E, 0x69, 0xDC, 0x06, 0xAA, 0x16, 0xA9, 0x95, 0x42, 0xD2, 0x81, 0x8A, 0x29, 0x00, 0x51, 0x45, 0x14, 0x00, 0x51, 0x45, 0x14, 0x00, 0x51, 0x45, 0x14, 0x00, 0x51, 0x45, 0x14, 0x00, 0x51, 0x45, 0x14, 0x00, 0x51, 0x45, 0x14, 0x00, 0x51, 0x45, 0x14, 0x00, 0x51, 0x45, 0x14, 0x00, 0x84, 0x70, 0x29, 0x68, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x0A, 0x28, 0xA2, 0x80, 0x3F, 0xFF, 0xD9};

// HTTP/1.1 200 OK
//Content-type:image/x-icon
const char favicon_ico[]={0x48, 0x54, 0x54, 0x50, 0x2F, 0x31, 0x2E, 0x31, 0x20, 0x32, 0x30, 0x30, 0x20, 0x4F, 0x4B, 0x0A, 0x43, 0x6F, 0x6E, 0x74, 0x65, 0x6E, 0x74, 0x2D, 0x74, 0x79, 0x70, 0x65, 0x3A, 0x20, 0x69, 0x6D, 0x61, 0x67, 0x65, 0x2F, 0x78, 0x2D, 0x69, 0x63, 0x6F, 0x6E,0x0D, 0x0A,0x0D, 0x0A, 
    0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x10, 0x10, 0x00, 0x00, 0x01, 0x00, 0x18, 0x00, 0x68, 0x03, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x01, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xED, 0xED, 0xED, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF6, 0xF6, 0xF6, 0xAD, 0xB4, 0xB3, 0xD9, 0xE0, 0xDF, 0xFA, 0xFA, 0xFA, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF5, 0xF5, 0xF5, 0xC8, 0xC8, 0xC8, 0x82, 0x5E, 0x64, 0x79, 0x56, 0x5C, 0xDF, 0xDF, 0xDF, 0xF7, 0xF7, 0xF7, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF7, 0xF7, 0xF7, 0xE4, 0xE4, 0xE4, 0x6F, 0x6F, 0x6F, 0xA6, 0x66, 0x66, 0x7C, 0x3A, 0x37, 0x64, 0x5B, 0x4F, 0xE1, 0xDC, 0xD5, 0xF8, 0xF8, 0xF8, 0xF6, 0xF6, 0xF6, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF9, 0xF9, 0xF9, 0x9B, 0x9B, 0x9B, 0x5B, 0x5B, 0x5B, 0x74, 0x5A, 0x3A, 0x7F, 0x62, 0x3E, 0x7A, 0x5F, 0x3A, 0x8B, 0x7D, 0x6A, 0xBC, 0xBC, 0xBC, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF6, 0xF6, 0xF6, 0x87, 0x86, 0x84, 0x67, 0x64, 0x61, 0x79, 0x5E, 0x41, 0x69, 0x4B, 0x2A, 0x97, 0x7F, 0x5E, 0x50, 0x41, 0x34, 0x2F, 0x2F, 0x2F, 0xBE, 0xBC, 0xBA, 0xF9, 0xF8, 0xF5, 0xF8, 0xF8, 0xF7, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xC6, 0xC6, 0xC6, 0x6C, 0x5B, 0x46, 0x7C, 0x60, 0x3D, 0x8C, 0x62, 0x64, 0x5E, 0x3A, 0x3F, 0x42, 0x42, 0x41, 0x39, 0x39, 0x39, 0x5B, 0x5B, 0x5B, 0x77, 0x61, 0x46, 0xC0, 0xAC, 0x8B, 0xF8, 0xF8, 0xF7, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF4, 0xF4, 0xF4, 0xA3, 0x93, 0x7E, 0x7C, 0x5F, 0x3A, 0x95, 0x6D, 0x6F, 0x5F, 0x3B, 0x41, 0x35, 0x35, 0x35, 0x47, 0x47, 0x47, 0x71, 0x71, 0x71, 0x69, 0x53, 0x37, 0x57, 0x3C, 0x19, 0xA0, 0xA0, 0x9F, 0xF3, 0xF3, 0xF3, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF6, 0xF2, 0xAD, 0xA7, 0x9F, 0x66, 0x3E, 0x44, 0x61, 0x37, 0x3E, 0x5D, 0x3A, 0x3F, 0x60, 0x4D, 0x50, 0xB8, 0xB8, 0xB8, 0x81, 0x42, 0x46, 0x7A, 0x26, 0x2A, 0x89, 0x46, 0x31, 0xD7, 0xB1, 0xA2, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF6, 0xF6, 0xF6, 0xD2, 0xB6, 0xBD, 0x7A, 0x4E, 0x55, 0x7C, 0x50, 0x57, 0x7F, 0x67, 0x6B, 0x7B, 0x7B, 0x7B, 0x82, 0x6C, 0x6F, 0x7B, 0x5D, 0x5F, 0x85, 0x75, 0x4F, 0xE6, 0xDC, 0xC5, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xFC, 0xF6, 0xF9, 0xD2, 0xC1, 0xC4, 0x8C, 0x77, 0x7A, 0x83, 0x78, 0x7A, 0x68, 0x68, 0x68, 0x94, 0x9A, 0x99, 0x8A, 0x92, 0x90, 0xBB, 0xC8, 0xB4, 0xF2, 0xF9, 0xEE, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF7, 0xF7, 0xF7, 0xCC, 0xCC, 0xCC, 0x70, 0x70, 0x70, 0x9C, 0x9C, 0x9C, 0x9A, 0x9A, 0x9A, 0xAA, 0xAA, 0xAA, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xDC, 0xDC, 0xDC, 0x79, 0x79, 0x79, 0xA8, 0xA8, 0xA8, 0xEE, 0xEE, 0xEE, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xEA, 0xEA, 0xEA, 0xEB, 0xEB, 0xEB, 0xF7, 0xF7, 0xF7, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

char rxBuff[BUFFER_SIZE];//array to store data received from esp
char reqLineBuff[REQ_LINE_BUFF_SIZE];
unsigned char reqLinBuffIndex=0;
unsigned int bufferWritingIndex=0;//write pointer
unsigned int bufferReadingIndex_IpdSearch=0;//read pointer
unsigned int bufferReadingIndex_espRespSearch=0;//read pointer
char serverIp[16];

Timer t;

void espRxInterrupt();
char readEspResponse();
void handleHttpRequests();
void processReqLine(char *stringToProcess);
void sendMemArrayToEsp(const char*str,unsigned int len);
void sendRequestedPageToClient(char id, const char* page,unsigned int len);
void extractQueryFieldValue(char* someUrl,char* field, char* value);
char toggleOutput(char* pinName);

int main(){
    //configure Pull down on all digital inputs
    digital_in_1.mode(PullDown);
    digital_in_2.mode(PullDown);
    digital_in_3.mode(PullDown);
    digital_in_4.mode(PullDown);

    //configure baud rate for UART
    pc.baud(115200);
    esp.baud(espbaud);

    esp2.attach(&espRxInterrupt,Serial::RxIrq);
    
    pc.printf("\033[0m\033[2J\033[HInitialise!\r\n\n\n");

    esp.printf("AT+RST\r\n");
    while(readEspResponse()!=READY);
    pc.printf("Reset success\n");    
    esp.printf("ATE0\r\n");//disable ECHO
    while(readEspResponse()!=OK);
    esp.printf("AT+CWMODE=1\r\n");//enable station mode
    while(readEspResponse()!=OK);
    esp.printf("AT+CIPMUX=1\r\n");// enable multiple connections
    while(readEspResponse()!=OK);
    esp.printf("AT+CIPSERVER=1,80\r\n");//start server at port 80
    while(readEspResponse()!=OK);    
    esp.printf("AT+CIPSTO=5\r\n");//Server timeout=5 seconds
    while(readEspResponse()!=OK);    

    pc.printf("Connecting to WiFi..");    
    char cmdbuff[60];
    strcpy(cmdbuff, "AT+CWJAP_CUR=\"");
    strcat(cmdbuff, ssid);
    strcat(cmdbuff, "\",\"");
    strcat(cmdbuff, pwd);
    strcat(cmdbuff, "\"\r\n");    
    esp.printf(cmdbuff);
    char responseFromEsp;
    
    while(1)
    {
        responseFromEsp=readEspResponse();
        wait_us(100000);
        pc.putc('.');
        if(responseFromEsp==OK || responseFromEsp==FAIL)
            break;
    }
    pc.putc('\n');
    if(responseFromEsp==OK)
    {
        pc.printf("Connected to Wifi\n");
        __disable_irq();
        esp.printf("AT+CIFSR\r\n");//check obtained IP
        esp.scanf("+CIFSR:STAIP,\"%15[^\"]",serverIp);
        __enable_irq();
        while(readEspResponse()!=OK);       
    }
     if(responseFromEsp==FAIL){
         pc.printf("Can't connect to Wifi\n");
         while(1);
         }
    
    pc.printf("Server IP is %s\n",serverIp);
        
    t.start();//start timer
    while(1){           
        handleHttpRequests();
    }
}

void espRxInterrupt(){
    if(esp2.readable())
    {
        rxBuff[bufferWritingIndex++]=esp2.getc();
        if(bufferWritingIndex>=BUFFER_SIZE)
            bufferWritingIndex=0;
    }
}

char readEspResponse(){
    char rxByte;
    char espResponse=UNKNOWN;
    static char state=0;

    while(bufferReadingIndex_espRespSearch!=bufferWritingIndex)
    {
        rxByte=rxBuff[bufferReadingIndex_espRespSearch++];
        //pc.putc(rxByte);
        if(bufferReadingIndex_espRespSearch>=BUFFER_SIZE)
            bufferReadingIndex_espRespSearch=0;

        switch(state)
        {
            case 0:
            if(rxByte=='O')//it may be OK response
                state=1;
            else if(rxByte=='E')//it may be ERROR response
                state=4;
            else if(rxByte=='F')//it may be FAIL response
                state=10;
            else if(rxByte=='r')//it may be 'ready' response
                state=15;
            else if(rxByte=='>')//it may be Ready To Write TCP '>' response
                state=21;
            break;

            case 1:
            if(rxByte=='K')
                state=2;
            else state=0;
            break;

            case 2:
            if(rxByte==0x0d)
                state=3;
            else state=0;
            break;

            case 3:
            if(rxByte==0x0A)
                espResponse=OK;
            state=0;
            break;

            case 4://ERROR
            if(rxByte=='R')
                state=5;
            else state=0;
            break;

            case 5:
            if(rxByte=='R')
                state=6;
            else state=0;
            break;

            case 6:
            if(rxByte=='O')
                state=7;
            else state=0;
            break;


            case 7:
            if(rxByte=='R')
                state=8;
            else state=0;
            break;

            case 8:
            if(rxByte==0x0d)
                state=9;
            else state=0;
            break;

            case 9:
            if(rxByte==0x0A)
                espResponse=ERROR;
            state=0;
            break;


            case 10://fail
            if(rxByte=='A')
                state=11;
            else state=0;
            break;


            case 11:
            if(rxByte=='I')
                state=12;
            else state=0;
            break;


            case 12:
            if(rxByte=='L')
                state=13;
            else state=0;
            
            break;

            case 13:
            if(rxByte==0x0d)
                state=14;
            else state=0;
            break;

            case 14:
            if(rxByte==0x0A)
                espResponse=FAIL;
            state=0;
            break;


            case 15://READY
            if(rxByte=='e')
                state=16;
            else state=0;
            break;


            case 16:
            if(rxByte=='a')
                state=17;
            else state=0;
            break;

            case 17:
            if(rxByte=='d')
                state=18;
            else state=0;
            break;

            case 18:
            if(rxByte=='y')
                state=19;
            else  state=0;
            break;

            case 19:
            if(rxByte==0x0d)
                state=20;
            else state=0;
            break;

            case 20:
            if(rxByte==0x0A)
                espResponse=READY;
            state=0;
            break;         

            case 21:
            if(rxByte==0x20)
                espResponse=READY_TO_WRITE_TCP;
            state=0;

            default:
            state=0;
            break;
        }
    }
    return espResponse;
}



void handleHttpRequests(){
    char rxByte;    
    static char state=0;

    while(bufferReadingIndex_IpdSearch!=bufferWritingIndex)
    {
        rxByte=rxBuff[bufferReadingIndex_IpdSearch++];
        //pc.putc(rxByte);
        if(bufferReadingIndex_IpdSearch>=BUFFER_SIZE)
            bufferReadingIndex_IpdSearch=0;
        switch(state)
        {
            case 0:
            if(rxByte=='+')
                state=1;
            break;

            case 1:
            if(rxByte=='I')
                state=2;
            else state=0;
            break;

            case 2:
            if(rxByte=='P')
                state=3;
            else state=0;
            break;

            case 3:
            if(rxByte=='D')
                state=4;
            else state=0;
            break;

            case 4:
            if(rxByte==',')
                state=5;
            else state=0;
            break;

            case 5:
            if(rxByte!=0x0d)
            {
                reqLineBuff[reqLinBuffIndex++]=rxByte;
            }
            else
            {
                reqLineBuff[reqLinBuffIndex]=0x00;
                bufferReadingIndex_espRespSearch=bufferReadingIndex_IpdSearch;
                processReqLine(reqLineBuff);
                state=0;
                reqLinBuffIndex=0;
            }
        }
    }
}

void processReqLine(char *stringToProcess)
{
//0,416:GET /?led=ON HTTP/1.1
    char requestType[6];
    char request[50];
    char linkId;
    int ipdLen;
    sscanf(stringToProcess,"%c,%d:%s %s",&linkId,&ipdLen,requestType,request);
    pc.printf("%s\n",request);
    if(request!=NULL)
    {
        if(strcmp(request,"/")==0 || strcmp(request,get_index_html)==0)
        {
            //send index.html
            sendRequestedPageToClient(linkId,index_html,sizeof(index_html)-1);
        }
        else if(strcmp(request,get_digital_inputs_html)==0)
        {
            sendRequestedPageToClient(linkId,digitalInputs_html,sizeof(digitalInputs_html)-1);
        }
        else if(strcmp(request,get_analog_inputs_html)==0)
        {
            sendRequestedPageToClient(linkId,analog_inputs_html,sizeof(analog_inputs_html)-1);

        }
        else if(strcmp(request,get_analog_outputs)==0)
        {
            sendRequestedPageToClient(linkId,analog_outputs_html,sizeof(analog_outputs_html)-1);
        }

        else if(strcmp(request,"/images/logo.jpg")==0)
        {
            sendRequestedPageToClient(linkId,logo_jpg,sizeof(logo_jpg));
        }
        else if(strcmp(request,"/favicon.ico")==0)
        {
            sendRequestedPageToClient(linkId,favicon_ico,sizeof(favicon_ico));
        }
        else if(strcmp(request,"/css/style.css")==0)
        {
            sendRequestedPageToClient(linkId,style_css,sizeof(style_css)-1);
        }
        else if(strncmp(request,get_Toggle_Output,strlen(get_Toggle_Output))==0)
        {
            //check query field and value, and toggle appropriate Output
            char field[10],value[10];
            extractQueryFieldValue(request,field,value);
            if(value!=NULL)
            {
                char newPinState=toggleOutput(value);
                char responsePacket[100];
                sprintf(responsePacket,"%s%c",textPlainHeader,newPinState+48);
                sendRequestedPageToClient(linkId,responsePacket,strlen(responsePacket));
            }
        }
        else if(strcmp(request,get_digital_output_status)==0)
        {
            //"{\"digital_outputs\":{\"dout1\":1,\"dout2\":0,\"dout3\":1,\"dout4\":1}}"
            char responsePacket[200];
            sprintf(responsePacket,"%s{\"digital_outputs\":{\"dout1\":%c,\
                            \"dout2\":%c,\"dout3\":%c,\"dout4\":%c}}",jsonHeader,(!digital_out_1)+48,
                            (!digital_out_2)+48,(!digital_out_3)+48,(!digital_out_4)+48);
            sendRequestedPageToClient(linkId,responsePacket,strlen(responsePacket));
        }
        else if(strcmp(request,get_digital_input_status)==0)
        {
            char responsePacket[200];
            sprintf(responsePacket,"%s{\"digital_inputs\":{\"din1\":%c,\
                            \"din2\":%c,\"din3\":%c,\"din4\":%c}}",jsonHeader,(digital_in_1)+48,
                            (digital_in_2)+48,(digital_in_3)+48,(digital_in_4)+48);
            sendRequestedPageToClient(linkId,responsePacket,strlen(responsePacket));

        }
        else if(strncmp(request,get_analog_output_update,strlen(get_analog_output_update))==0)
        {
            char field[10],value[10];
            extractQueryFieldValue(request,field,value);
            if(value!=NULL)
            {
                analog_out_1=atof(value)/12.0;
                char responsePacket[100];
                sprintf(responsePacket,"%s%.2f",textPlainHeader,analog_out_1.read()*12.0f);
                sendRequestedPageToClient(linkId,responsePacket,strlen(responsePacket));
            }
        }
        else if(strcmp(request,get_analog_outputs_status)==0)
        {           
            char responsePacket[100];
            sprintf(responsePacket,"%s%.2f",textPlainHeader,analog_out_1.read()*12.0f);
            sendRequestedPageToClient(linkId,responsePacket,strlen(responsePacket));
        }
        else if(strcmp(request,get_analog_inputs_status)==0)
        {
            char responsePacket[100];           
            sprintf(responsePacket,"%s%.2f",textPlainHeader,((tempSensor*3.3f)-0.500f)*100.0f);
            sendRequestedPageToClient(linkId,responsePacket,strlen(responsePacket));
        }
        else 
        {
            sendRequestedPageToClient(linkId,not_found_text,sizeof(not_found_text)-1);
            //send page not found message
        }
    }
}


void sendRequestedPageToClient(char id, const char* page,unsigned int len)
{
    char atCommandArray[50];
    unsigned int lenOfPacketToTx;
    unsigned int pageToSendAddress=0;
    char tempEspStatus;
    while(len>0)
    {
        if(len>2048){
            len-=2048;        
            lenOfPacketToTx=2048;
        }
        else{
            lenOfPacketToTx=len;
            len=0;
        }
        
        sprintf(atCommandArray,"AT+CIPSEND=%c,%d\r\n",id,lenOfPacketToTx);  
        bufferReadingIndex_espRespSearch=bufferWritingIndex;
        esp.printf(atCommandArray);
     
        while(1)
        {
            tempEspStatus=readEspResponse();  
            if(tempEspStatus==READY_TO_WRITE_TCP||tempEspStatus==ERROR ||tempEspStatus==FAIL)
                break;
        }    
        //now send page
        if(tempEspStatus==READY_TO_WRITE_TCP)
        {
            sendMemArrayToEsp(page+pageToSendAddress,lenOfPacketToTx);
            do{
                tempEspStatus=readEspResponse();
            }
            while(tempEspStatus==UNKNOWN);
            if(tempEspStatus!=OK)//link broken, don't send more data to this link.
                break;

            pageToSendAddress+=lenOfPacketToTx;
        }
        else
            break;
    }
    if(tempEspStatus==OK)
    {
        sprintf(atCommandArray,"AT+CIPCLOSE=%c\r\n",id);
        esp.printf(atCommandArray);
        while(readEspResponse()==UNKNOWN);
    }
}

void sendMemArrayToEsp(const char*str,unsigned int len)
{
    while(len--)
        esp.putc(*str++);
}

void extractQueryFieldValue(char* someUrl,char* field, char* value)
{   
    sscanf(someUrl,"%*[^?]%*c%[^=]%*c%s",field,value);
}

char toggleOutput(char* pinName)
{
    if(strcmp(pinName,"dout1")==0)
    {
        digital_out_1=!digital_out_1;
        return !digital_out_1;
    }
    else if(strcmp(pinName,"dout2")==0)
    {
        digital_out_2=!digital_out_2;
        return !digital_out_2;
    }
    else if(strcmp(pinName,"dout3")==0)
    {
        digital_out_3=!digital_out_3;
        return !digital_out_3;
    }
    else if(strcmp(pinName,"dout4")==0)
    {
        digital_out_4=!digital_out_4;
        return !digital_out_4;
    }
    else return 2;//error

}
 
 