#include    "mbed.h"

class I2cBusDevice {
public:

    I2cBusDevice( I2C *LCD, char dev_address ) {
        bus          = LCD;
        device       = dev_address;
    }

    ~I2cBusDevice() {
    }

    int write( char *data, int length ) {
        return ( bus->write( device, data, length) );
    }
    
    int read( char *data, int length ) {
        return ( bus->read( device, data, length) );
    }

    int read( char reg_ptr, char *data, int length ) {
        if ( bus->write( device, &reg_ptr, 1 ) )
            return ( 1 );
        if ( bus->read( device, data, length ) )
            return ( 1 );
        return ( 0 );
    }

protected:
    I2C     *bus;
    char    device;
}
;


