#ifndef __BUrtc_H
#define __BUrtc_H

#include "mbed.h"
#include "em_emu.h"
#include "em_rmu.h"
#include "em_burtc.h"

#define UINT32_MAX       4294967295UL

/* This variables must reflect BURTC frequency */
#define COUNTS_PER_SEC (32768/128)
/* Clock defines */
#define LFXO_FREQUENCY 32768
#define BURTC_PRESCALING 128
#define UPDATE_INTERVAL 1
//#define COUNTS_PER_SEC (LFXO_FREQUENCY/BURTC_PRESCALING)
#define COUNTS_BETWEEN_UPDATE (UPDATE_INTERVAL*COUNTS_PER_SEC)


void BUrtcInit(void);
void budSetup(void);
void burtcSetup(void);
void RTCset(int seconds);
void RTCrestore(void);
void BURTC_IRQHandler(void);
void BUrtcBackup(void);

static int burtcCount;
static int burtcOverflowCounter;
static int burtcOverflowIntervalRem;
static int burtcTimestamp;
static int rtcStartTime;
static int rtcOverflowCounter;
static int overflow_interval;
static int overflow_interval_r;

static int trtc;
static int lcdUpdate;
static int resetcause;

#endif
