
#include "mbed.h"
#include "EFM32_SegmentLCD.h"
#include "EFM32_CapSenseSlider.h"
#include "BUrtc.h"

silabs::EFM32_SegmentLCD segmentDisplay;
silabs::EFM32_CapSenseSlider capSlider;

InterruptIn MinMonth(SW0);
InterruptIn HourDate(SW1);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

char timebuff[20], lcdTime[8];
int initialized = false;
int month,date,lcdDate,slider;

struct tm t;

void displayRefresh(),timeSet(),dateSet();

int main()
{
    // set up BU domain and BUrtc if not started, else restore system RTC from BUrtc
    BUrtcInit();
    
    // set the reset time
    t.tm_sec    = 0;    // 0-59
    t.tm_min    = 0;    // 0-59
    t.tm_hour   = 0;   // 0-23
    t.tm_mday   = 17;   // 1-31
    t.tm_mon    = 4;    // 0-11
    t.tm_year   = 116;  // years since 1900
    
    // time setting button interrupts
    HourDate.fall(&timeSet);
    MinMonth.fall(&timeSet);
    capSlider.start();
    capSlider.attach_slide(-1, dateSet);

    while(1) {

        // Sleep while waiting for interrupt
        EMU_EnterEM2(true);
        // Run display update code on wake up
        displayRefresh();
    }
}

void displayRefresh()
{    
     if (!initialized) {
            segmentDisplay.Symbol(LCD_SYMBOL_COL3,true);
            segmentDisplay.Symbol(LCD_SYMBOL_COL5,true);
            SegmentLCD_Symbol(LCD_SYMBOL_DP10, true);
            // set time if RTC is reset
            if(time(NULL)<10) {
                RTCset(mktime(&t));
            }
            initialized = true;
        }
        time_t seconds = time(NULL);
        strftime(timebuff, 2,"%d", localtime(&seconds));
        date = atoi(timebuff);
        strftime(timebuff, 2,"%m", localtime(&seconds));
        month = atoi(timebuff);
        lcdDate = ((date %31)* 100 + (month % 12));
        strftime(lcdTime,8,"%H%M%S", localtime(&seconds));

        SegmentLCD_Write(lcdTime);
        segmentDisplay.Number(lcdDate);
        segmentDisplay.Symbol(LCD_SYMBOL_EFM32, seconds & 0x1);
        led1=0;led2=0;
}

void dateSet() {
    
    // set date by tapping slider, slow and fast settings    
    slider = capSlider.get_position();
    led2=!led2;    
    time_t seconds = time(NULL);  
    seconds=seconds + (86400 * (slider/10));    
    RTCset(seconds);    
}

void timeSet()
{
    // set hours and minutes with buttons, set date first, can't go backwards
    led1=!led1;
    time_t seconds = time(NULL);  
    if(MinMonth){seconds=seconds+60;}
    if(HourDate){seconds=seconds+3600;}     
    RTCset(seconds);    
}

