/* mbed Library - Nokia LCD Labelled "X3"
* This is using the Philips PCF8833 controller
 * Copyright (c) 2009 P.R.Green
 */

#ifndef MBED_MOBILELCD_H
#define MBED_MOBILELCD_H

//Colours in RGB 5:6:5 16bit mode
#define BLACK       0x0000
#define RED         0xF800
#define GREEN       0x07E0 
#define BLUE        0x001F
#define WHITE       0xFFFF
#define YELLOW      0xFF00
#define MAGENTA     0xF0F0
#define CYAN        0x05FC

#include "mbed.h"


namespace mbed {

/* Class: MobileLCD
 *  An abstraction of the 130x130 Nokia Mobile labelled "X3" phone screen
 *
 * Example:
 * >
 * > #include "mbed.h"
 * > #include "MobileLCD.h"
 * >
 * > MobileLCD lcd(p5,p6,p7,p8,p9);
 * > 
 * > int main() {
 * >     lcd.printf("Hello World!");
 * > }
 */

class MobileLCD : public Stream {

public:
    /* Constructor: MobileLCD
     *  Create and object for the Mobile LCD, using SPI and two DigitalOuts
     *
     * Variables:
     *  mosi - SPI data out
     *  miso - SPI data in, not used
     *  clk  - SPI clock
     *  cs   - Chip Select
     *  rst  - reset
     */

    MobileLCD(PinName mosi, PinName miso, PinName clk, PinName cs, PinName rst);

    virtual void reset();
    virtual void _select();
    virtual void _deselect();
    virtual void _window(int x, int y, int width, int height);
    virtual void _putp(int colour);
    //virtual void orientation();

     void command(int value);
     void data(int value);
     void foreground(int v);
     void background(int v);
     /* Function: locate
      *  Set the text cursor to location x,y
      *
      * Variables:
      *  x - An integer setting the column position
      *  y - An integer setting the row position
      */
     void locate(int column, int row);
     /* Function: newline
      *  Set the text cursor to the start of the next line
      */
     void newline();
     virtual int _putc(int c);
     virtual int _getc() { return 0; }
    SPI _spi;
    DigitalOut _rst;
    DigitalOut _cs;    
    void bitblit(int x, int y, int width, int height, const char* bitstream);
    void fill(int x, int y, int width, int height, int colour);
    void blit(int x, int y, int width, int height, const int* colour);
    /* Function: cls
     *  Clear the screen
     */
    void cls();
    int width();
    int height();
    int columns();
    int rows();
    void putp(int v);
    void window(int x, int y, int width, int height);
    void pixel(int x, int y, int colour);
    int _row, _column, _rows, _columns, _foreground, _background, _width, _height;
};

}

#endif
    

