#ifndef BME_H
#define BME_H

#include "mbed.h"

#define _debug   1      // '1' to enable prinf BME's registers

/*
Bosch Sensortec BMP280 BME280 i2c example code
using 64bit numeric calculations as recomended by Bosch.
Some sensors supplied from Chinese suppliers may have 'suspect'
quality sensor with different i2c address.
My sensors were address 0xEC and all the ones I have
differ quite a bit in tolerance :( so be aware if accuracy is paramount.
*/

/*
#include "mbed.h"
#include "BME280.h"

BME sensor(D0,D1, 0xEC); // sda, clk, 8bit address (NUCLEO-L432)
DigitalOut led(LED1);

float temp, humidity, pressure, altitude;

int main()
{

    int BMPE_id = sensor.init();    // initialise and get sensor id

    if(!BMPE_id) {
        printf("No sensor detected!!\n");
        while(1){
            led=!led;
            ThisThread::sleep_for(200ms);
        }
    }
     
    if(_debug){ // set _debug to '1' to see BME's registers
        ThisThread::sleep_for(2s);
        }
    
    while(1) {
        led=1;
        printf("\033[0m\033[2J\033[H------- BME280-BMP280 Sensor example -------\r\n\n");
        if(BMPE_id==0x60) {
            printf("BME280 detected id: 0x%x\n\n",BMPE_id);
        } else if(BMPE_id==0x58) {
            printf("BMP280 detected id: 0x%x\n\n",BMPE_id);
        }

        temp = sensor.getTemperature();
            
        printf("Temperature: %3.2f %cc \n",temp,0xb0);

        if(sensor.chip_id==0x60) {        // only BME has Humidity
            humidity    = sensor.getHumidity();
            printf("Humidity:    %2.2f %cRh \n", humidity,0x25);
        }
        pressure    = sensor.getPressure();
        printf("Pressure:    %4.2f mbar's \n\n",pressure);

        altitude = 44330.0f*( 1.0f - pow((pressure/1013.25f), (1.0f/5.255f)))+18;     // Calculate altitude in meters
        printf("Altitude: %3.1f meters   %4.1f feet \r\n(Referenced to 1,013.25 millibars @ sea level) \r\n\n", altitude,altitude*3.2810f);
        led=0;
        ThisThread::sleep_for(1s);
    }
}
*/

class BME
{
public:

    BME(PinName sda, PinName scl, char slave_adr);

    int         init(void);
    int         chipID(void);
    float       getTemperature(void);
    float       getPressure(void);
    float       getHumidity(void);
  
    uint16_t    chip_id;

private:

    I2C         bme;
    void        initialize(void);
    char        address;
    uint16_t    dig_T1;
    int16_t     dig_T2, dig_T3;
    uint16_t    dig_P1;
    int16_t     dig_P2, dig_P3, dig_P4, dig_P5, dig_P6, dig_P7, dig_P8, dig_P9;
    uint16_t    dig_H1, dig_H3;
    int16_t     dig_H2, dig_H4, dig_H5, dig_H6;
    int32_t     t_fine;
    bool        dbg_on;
};
#endif // BME_H
