//  mbed library for 4DSystems uOLED-32028-P1T

//  *****OLED_BAUDRATE must start at 9600*******

#define BAUDRATE                        9600  // MUST use 9600 here to initialise display, can be redefined upto 256K in OLED3208P1T.cpp

// Screen states
#define OFF                             0x00
#define ON                              0x01

// Text properties
#define TEXT                            0x73
#define FONT5X7                         0x00
#define FONT8X8                         0x01
#define FONT8X12                        0x02
#define FONT12X16                       0x03
#define TEXTFORMATED                    0x54
#define SET_TEXT_BACKGROUND_TYPE        0x4F
#define SET_BACKGROUND_COLOR            0x42
#define TEXT_TRANSPARENT                0x00
#define TEXT_OPAQUE                     0x01
#define OLED_TEXT_BUTTON                0x62

// Colours
#define BLACK                           0x0000
#define WHITE                           0xFFFF
#define RED                             0xF800
#define GREEN                           0x07E0
#define BLUE                            0x001F
#define YELLOW                          0xFFE0
#define CYAN                            0x07FF
#define MAGENTA                         0xF81F
#define BLUE2                           0xA6BF
#define GREEN2                          0x2500

#define red_min 0//150
#define red_max 255
#define blue_min 0//185
#define blue_max 255
#define green_min 0//195
#define green_max 255

class OLED32028P1T : public Stream {
public:

    OLED32028P1T(PinName serialTx, PinName serialRx, PinName resetPin); // Default constructor
    
// TEXT FUNCTIONS     
    void setFontSize(int fontSize); // fontSize can be: OLED_FONT5X7, OLED_FONT8X8, or OLED_FONT8X12
    void setFontColor(int fontColor); // Set font color, for use with printf(); all other functions override this setting.
    void drawText(int  column, int row, int font_size, char *mytext, int color); // Draw string text at character location column & row)
    void drawSingleChar(int column, int row, int theChar, int color); // Draw a single ASCII character at the specified location.   
    void drawTextGraphic(int x, int y, int font_size, char *mytext, int color, int width, int height); // Draw string text at pixel location x & y)
// GRAPHIC FUNCTIONS
    void drawCircle(int x, int y, int radius, int color);
    void drawRectangle(int x, int y, int width, int height, int color);
    void drawLine(int x1, int y1, int x2, int y2, int color);
    void drawPixel(int x, int y, int color);   
    void drawTextButton(int up_down, int x, int y, int button_colour, int font, int string_colour, int width, int height, char *mytext);
    
// TOUCH FUNCTIONS
    void enableTouch(); // Enables the Touch Screen
    void disableTouch(); // Disables the Touch Screen   
    void setTouchArea(int, int, int, int); // define Touch Area 0,0,219,239 for whole screen 
    void resetTouchArea(); // Resets Touch Area to whole screen
    void waitTouch(int); // wait for Touch, wait time in milliseconds. Maximum value of 65,535 msec or 65.5 seconds used for delay in sd card image display.     
    unsigned char getTouch(int *xbuffer, int *ybuffer); // get Touch co-ordiantes
    unsigned char getTouchRelease(int *xbuffer, int *ybuffer); // get Touch Release co-ordiantes
    unsigned char getTouchPress(int *xbuffer, int *ybuffer); // get Touch Press co-ordiantes 
    
    
// SD FUNCTIONS 
    unsigned char stringSD(int, int, int, int, int, unsigned char, unsigned char, int, int, char[]);
    unsigned char imageSD(int , int , char[]);   
    
// DISPLAY CONTROL FUNCTION 
    void resetDisplay(); // Reset the display using the reset pin (the reset pin is active-low).    
    void init(); // Initialise OLED display.    
    void baudReset();
    void getResponse(); // Processes responses (ACK or NAK) from the OLED. A new command cannot be sent to the OLED until a NAK is received, so
                        // this function waits for the minimum time needed.    
    void clear(); // Clear the OLED screen.
    void setPenSize(int penSize); // Set the "pen size".
    void setTextBackgroundType(int textBackgroundType); //textBackgroundType can be OLED_SET_TEXT_TRANSPARENT or OLED_SET_TEXT_OPAQUE
    void setBackgroundColor(int color);   
    int toRGB(int red, int green, int blue);// Calculate 16-bit value from RGB (0 to 63, 565 format)
    void displayControl(int mode, int value); // Display control functions, such as display ON/OFF, power-up/power-down.
    void displayOff();
    void displayOn();
    void displaySleep();   
    char getPenSize(); // Get Pen Size
    int rows();  //Get number of text rows TODO: must depend on font size
    int columns();// Get number of text columns    
    virtual void locate(int column, int row);// Set text cursor location   
    int lastCount;    
    int NAKCount;
        
protected:
    virtual int _putc(int value);
    virtual int _getc();
    short _column;   //Text cursor column number
    short _row;   //Text cursor row number    
    int _fontSize;
    int _penSize;
    int _fontColor;
    
private:
    Serial s;
    DigitalOut  reset;   
};
