//  mbed library for 4DSystems uOLED-32028-P1T
#include "mbed.h"
#include "OLED32028P1T.h"

OLED32028P1T::OLED32028P1T(PinName serialTx, PinName serialRx, PinName resetPin) : s(serialTx, serialRx), reset(resetPin){
    s.baud(BAUDRATE);
    while (s.readable()) {
        s.getc();
} }
// Initialise OLED display and redifine baud faster baud rate.
void OLED32028P1T::init(){
    resetDisplay();
    s.putc(0x55);   // send byte for OLED to autodetect baudrate
    getResponse();
    s.putc (0x51); // send code to display to change baud rate    
    #if defined(TARGET_KL05Z) 
    s.putc (0x0E); // send new display baud rate from list below, upto 128k    
    #elif defined(TARGET_KL25Z) 
    s.putc (0x0E); // send new display baud rate from list below, upto 128k
    #else
    s.putc (0x0F); // send new display baud rate from list below, maximun 282353  
    #endif
    /*
            00hex : 110 Baud
            01hex : 300 Baud
            02hex : 600 Baud
            03hex : 1200 Baud
            04hex : 2400 Baud
            05hex : 4800 Baud
            06hex : 9600 Baud
            07hex : 14400 Baud
            08hex : 19200 Baud
            09hex : 31250 Baud
            0Ahex : 38400 Baud
            0Bhex : 56000 Baud
            0Chex : 57600 Baud
            0Dhex : 115200 Baud
            0Ehex : 128000 Baud (It is actually 129032Baud)
            0Fhex : 256000 Baud (It is actually 282353Baud)
            10hex : 128000 Baud
            11hex : 256000 Baud
     */       
    wait_ms(10);
    #undef BAUDRATE    
    #if defined(TARGET_KL05Z)
    #define BAUDRATE  129032 // ***** set matching new display baud rate, upto 128k *****
    #elif defined(TARGET_KL25Z)
    #define BAUDRATE  129032 // ***** set matching new display baud rate, upto 128k *****    
    # else
    #define BAUDRATE  282353 // ***** set matching new display baud rate, maximum 282353 *****   
    #endif
    s.baud(BAUDRATE);
    while (s.readable()) {
    s.getc();
} }
void OLED32028P1T::resetDisplay(){
    reset = 0;
    wait_ms(200);
    reset = 1;
    wait_ms(1000);
}
void OLED32028P1T::displayControl(int mode, int value){
    s.putc(0x59);
    s.putc(mode);
    s.putc(value);
    getResponse();
}
void OLED32028P1T::displayOff(){
    s.putc(0x59);
    s.putc(0x01);
    s.putc(0x00);
    getResponse();
}
void OLED32028P1T::displayOn(){
    s.putc(0x59);
    s.putc(0x01);
    s.putc(0x01);
    getResponse();
}
void OLED32028P1T::displaySleep(){
    s.putc(0x5A);
    s.putc(0x02);
    s.putc(0xFF);
    while (!s.readable()){}
    
}
void OLED32028P1T::getResponse(){
    char response = 0x15;
    lastCount = 0;
    NAKCount = 0;
    while (!s.readable() || response == 0x15) {
        wait_ms(1);
        lastCount++;
        if (s.readable()) {
            response = s.getc();    // Read response
            if (response == 0x06) {
                return;
            } else if (response == 0x15) {
                NAKCount++;
} } } }
int OLED32028P1T::toRGB(int red, int green, int blue){
    int outR = ((red * 31) / 255);
    int outG = ((green * 63) / 255);
    int outB = ((blue * 31) / 255);
    return (outR << 11) | (outG << 5) | outB;
}
void OLED32028P1T::clear(){
    s.putc(0x45);
    getResponse();
    _row = 0;
    _column = 0;
}
void OLED32028P1T::drawPixel(int x, int y, int color){
    s.putc(0x50);
    s.putc(x >> 8);
    s.putc(x & 0xFF);
    s.putc(y >> 8);
    s.putc(y & 0xFF); 
    s.putc(color >> 8);     // MSB
    s.putc(color & 0xFF);   // LSB
    getResponse();
}
void OLED32028P1T::drawLine(int x1, int y1, int x2, int y2, int color){
    s.putc(0x4C);      // Line
    s.putc(x1 >> 8);
    s.putc(x1 & 0xFF);
    s.putc(y1 >> 8);
    s.putc(y1 & 0xFF);
    s.putc(x2 >> 8);
    s.putc(x2 & 0xFF);
    s.putc(y2 >> 8);
    s.putc(y2 & 0xFF);
    s.putc(color >> 8);      // MSB
    s.putc(color & 0xFF);    // LSB
    getResponse();
}
void OLED32028P1T::drawRectangle(int x, int y, int width, int height, int color){
    s.putc(0x72);
    s.putc(x >> 8);
    s.putc(x & 0xFF);
    s.putc(y >> 8);
    s.putc(y & 0xFF);
    s.putc(x+width >> 8);
    s.putc(x+width & 0xFF);
    s.putc(y+height >> 8);
    s.putc(y+height & 0xFF);
    s.putc(color >> 8);      // MSB
    s.putc(color & 0xFF);    // LSB
    getResponse();
}
void OLED32028P1T::drawCircle(int x, int y, int radius, int color){
    s.putc(0x43);
    s.putc(0);
    s.putc(x);
    s.putc(0);
    s.putc(y);
    s.putc(0);
    s.putc(radius);
    s.putc(color >> 8);     // MSB
    s.putc(color & 0xFF);   // LSB
    getResponse();
}
void OLED32028P1T::setFontSize(int fontSize){
    s.putc(0x46);
    s.putc(fontSize);
    _fontSize = fontSize;
    getResponse();
}
void OLED32028P1T::setFontColor(int fontColor){
    _fontColor = fontColor;
}
void OLED32028P1T::setPenSize(int penSize){
    s.putc(0x70);
    s.putc(penSize);
    _penSize = penSize;
    getResponse();
}
void OLED32028P1T::setTextBackgroundType(int textBackgroundType){
    s.putc(0x4F);
    s.putc(textBackgroundType);
    getResponse();
}
void OLED32028P1T::setBackgroundColor(int color){
    s.putc(0x42);
    s.putc(color >> 8);      // MSB
    s.putc(color & 0xFF);    // LSB
    getResponse();
}
void OLED32028P1T::drawText(int column, int row, int font_size, char *mytext, int color){
    s.putc(0x73);
    // Adjust to center of the screen (26 Columns at font size 0)
    //int newCol = 13 - (strlen(mytext)/2);
    //printByte(newCol); // column
    s.putc(column); // column
    s.putc(row); // row
    s.putc(font_size); // font size (0 = 5x7 font, 1 = 8x8 font, 2 = 8x12 font, 3 = 12x16)
    s.putc(color >> 8);      // MSB
    s.putc(color & 0xFF);    // LSB
    for (int i = 0;  i < strlen(mytext); i++) {
        s.putc(mytext[i]); // character to write
    }
    s.putc(0x00);   // string terminator (always 0x00)
    getResponse();
}
void OLED32028P1T::drawTextGraphic(int x, int y, int font_size, char *mytext, int width, int height, int color){
    s.putc(0x53);        
    s.putc(x >> 8); //MSB
    s.putc(x & 0xFF); //LSB
    s.putc(y >> 8); // MSB
    s.putc(y & 0xFF); //LSB    
    s.putc(font_size); // font size (0 = 5x7 font, 1 = 8x8 font, 2 = 8x12 font, 3 = 12x16)
    s.putc(color >> 8);      // MSB
    s.putc(color & 0xFF);    // LSB
    s.putc(width); // character width
    s.putc(height); // character height
    for (int i = 0;  i < strlen(mytext); i++) {
        s.putc(mytext[i]); // character to write
    }
    s.putc(0x00);   // string terminator (always 0x00)
    getResponse();
}
void OLED32028P1T::drawSingleChar(int column, int row, int theChar, int color){
    s.putc(0x54);
    s.putc(theChar);
    s.putc(column);
    s.putc(row);
    s.putc(color >> 8);      // MSB
    s.putc(color & 0xFF);    // LSB
    getResponse();
}
char OLED32028P1T::getPenSize(){
    return _penSize;
}
void OLED32028P1T::drawTextButton(int up_down, int x, int y, int button_colour, int font, int string_colour, int width, int height, char *mytext){
    s.putc(0x62);    
    s.putc(up_down);    
    s.putc(x >> 8);
    s.putc(x & 0xFF);
    s.putc(y >> 8);
    s.putc(y & 0xFF);    
    s.putc(button_colour >> 8);
    s.putc(button_colour & 0xFF);   
    s.putc(font); 
    s.putc(string_colour >> 8);
    s.putc(string_colour & 0xFF);    
    s.putc(width);
    s.putc(height);    
    for (int i = 0;  i < strlen(mytext); i++) {
        s.putc(mytext[i]); // characters to write
    }   
    s.putc(0x00);   
    getResponse();
}
void OLED32028P1T::enableTouch(){
    s.putc(0x59); // display control command
    s.putc(0x05); // Touch Control
    s.putc(0x00); // enable Touch
    getResponse();
}
void OLED32028P1T::disableTouch(){
    s.putc(0x59); // display control command
    s.putc(0x05); // Touch Control
    s.putc(0x01); // disable Touch
    getResponse();
}    
unsigned char OLED32028P1T::getTouch(int *xbuffer, int *ybuffer){  //Touch Press on the screen, if return=1, touch coordinates are stored on the buffer[]
  
  //xbuffer=0;ybuffer=0;
  s.putc(0x6F);
  s.putc(0x04);
  xbuffer[0]=s.getc();
  xbuffer[0]=xbuffer[0]<<8;
  xbuffer[0]|=s.getc();
  ybuffer[0]=s.getc();
  ybuffer[0]=ybuffer[0]<<8;
  ybuffer[0]|=s.getc();
  
  if(xbuffer[0] !=  0){
  s.putc(0x6F);
  s.putc(0x05);
  xbuffer[0]=s.getc();
  xbuffer[0]=xbuffer[0]<<8;
  xbuffer[0]|=s.getc();
  ybuffer[0]=s.getc();
  ybuffer[0]=ybuffer[0]<<8;
  ybuffer[0]|=s.getc(); 
    return 1;
  }else{
    return 0;
  }  
}
unsigned char OLED32028P1T::getTouchPress(int *xbuffer, int *ybuffer){  //Touch Release on the screen, if return=1, touch coordinates are stored on the buffer[]
  s.putc(0x6F);
  s.putc(0x01);
  xbuffer[0]=s.getc();
  xbuffer[0]=xbuffer[0]<<8;
  xbuffer[0]|=s.getc();
  ybuffer[0]=s.getc();
  ybuffer[0]=ybuffer[0]<<8;
  ybuffer[0]|=s.getc();
  
  if(xbuffer[0] !=  0){
  s.putc(0x6F);
  s.putc(0x05);
  xbuffer[0]=s.getc();
  xbuffer[0]=xbuffer[0]<<8;
  xbuffer[0]|=s.getc();
  ybuffer[0]=s.getc();
  ybuffer[0]=ybuffer[0]<<8;
  ybuffer[0]|=s.getc(); 
    return 1;
  }else{
    return 0;
  }  
}
unsigned char OLED32028P1T::getTouchRelease(int *xbuffer, int *ybuffer){  //Touch Release on the screen, if return=1, touch coordinates are stored on the buffer[]
  s.putc(0x6F);
  s.putc(0x02);
  xbuffer[0]=s.getc();
  xbuffer[0]=xbuffer[0]<<8;
  xbuffer[0]|=s.getc();
  ybuffer[0]=s.getc();
  ybuffer[0]=ybuffer[0]<<8;
  ybuffer[0]|=s.getc();
  
  if(xbuffer[0] !=  0){
  s.putc(0x6F);
  s.putc(0x05);
  xbuffer[0]=s.getc();
  xbuffer[0]=xbuffer[0]<<8;
  xbuffer[0]|=s.getc();
  ybuffer[0]=s.getc();
  ybuffer[0]=ybuffer[0]<<8;
  ybuffer[0]|=s.getc(); 
    return 1;
  }else{
    return 0;
  }  
}
void OLED32028P1T::setTouchArea(int x1, int y1 , int x2, int y2) { // define touch area
    char command[9]= "";int i;
    command[0] = (0x75);
    command[1] = (x1 >> 8) & 0xFF;
    command[2] = x1 & 0xFF;
    command[3] = (y1 >> 8) & 0xFF;
    command[4] = y1 & 0xFF;
    command[5] = (x2 >> 8) & 0xFF;
    command[6] = x2 & 0xFF;
    command[7] = (y2 >> 8) & 0xFF;
    command[8] = y2 & 0xFF;
    for (i = 0; i < 9; i++) s.putc(command[i]);     
     getResponse();
}
void OLED32028P1T::resetTouchArea(){
    s.putc(0x59); // display control command
    s.putc(0x05); // Touch Control
    s.putc(0x02); // reset Touch Area to whole screen
    getResponse();
}  
void OLED32028P1T::waitTouch(int x){
    s.putc(0x77); // wait Touch command
    s.putc(x >> 8);      // MSB
    s.putc(x & 0xFF);    // LSB    
    getResponse();
}
unsigned char OLED32028P1T::stringSD(int x1, int y1, int x2, int y2, int colour, unsigned char font, unsigned char fill, int BS, int BR, char name[]){
       //Draw a String from a text file contained on the micro SD card on the screen
  unsigned char counter=0;  
  s.putc('S'); 
  s.putc('S'); //from SD
  s.putc(x1>>8); 
  s.putc(x1);
  s.putc(y1>>8);
  s.putc(y1);
  s.putc(x2>>8); 
  s.putc(x2);
  s.putc(y2>>8);
  s.putc(y2);  
  s.putc(colour>>8);
  s.putc(colour);
  s.putc(font); 
  s.putc(fill); 
  s.putc(BS>>8);
  s.putc(BS);  
  s.putc(BR>>8);
  s.putc(BR);  
  while(1){
    s.putc(name[counter]);
    if(name[counter]==0x00){
      break;
    }    
    counter++;
  }
  return s.getc();
}
unsigned char OLED32028P1T::imageSD(int x, int y, char name[]){
        //Draw an Image contained on the micro SD card on the screen, top left corner coordinates
  unsigned char counter=0;  
  s.putc('I'); 
  s.putc('S'); //from SD
  s.putc(x>>8); 
  s.putc(x);
  s.putc(y>>8);
  s.putc(y);
  while(1){
    s.putc(name[counter]);
    if(name[counter]==0x00){
      break;
    }    
    counter++;
  }
  return s.getc();
}
int OLED32028P1T::_putc(int value){
    if (value == '\n') {
        _column = 0;
        _row++;
        if(_row >= rows()) {
            _row = 0;
        }
    } else {
        drawSingleChar(_column, _row, value, _fontColor);
        wait_ms(1);    //TODO: why is this needed?
        _column++;
        if (_column >= columns()) {
            _column = 0;
            _row++;
            if(_row >= rows()) {
                _row = 0;
        } } }
    return value;
}
void OLED32028P1T::locate(int column, int row){
    _column = column;
    _row = row;
}
int OLED32028P1T::rows(){
    return 30;
}
int OLED32028P1T::columns(){
    return 55;
}
int OLED32028P1T::_getc(){
    return -1;
}
