#include "Led_Lcd.h"

#include "LCD_DISCO_F429ZI.h"
LCD_DISCO_F429ZI lcd;

LedLcd::LedLcd(unsigned char ucLedColumnIndex){
    lcd.Clear(LCD_COLOR_BLACK);
    ucLedColumnPosition = ucLedColumnIndex*80;
}    

void LedLcd::On(unsigned char ucLedIndex){
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillRect(ucLedColumnPosition, 0, 80, 320);
    
    lcd.SetTextColor(LCD_COLOR_GREEN);
    
    switch(ucLedIndex){
        case 0:
            lcd.FillRect(ucLedColumnPosition, 0, 80, 80);
        break;
        case 1:
            lcd.FillRect(ucLedColumnPosition, 80, 80, 80); 
        break;
        case 2:
            lcd.FillRect(ucLedColumnPosition, 160, 80, 80);
        break;
        case 3:
            lcd.FillRect(ucLedColumnPosition, 240, 80, 80); 
        break;
        default:
        break;
    }
    
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetFont(&Font24);

    for(int i=0; i<4; i++){
        char number_string [2] = {'0' + i, 0};
        lcd.DisplayStringAt(ucLedColumnPosition, 80*i, (uint8_t *) number_string , LEFT_MODE);
    }
                    
    lcd.SetTextColor(LCD_COLOR_GREEN);
    for(int green_frame_count=0; green_frame_count<4; green_frame_count++){
        lcd.DrawRect(ucLedColumnPosition, green_frame_count*80, 80, 80);
    }
}