/*
 * FreeModbus Libary: BARE Port
 * Copyright (C) 2006 Christian Walter <wolti@sil.at>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * File: $Id: portserial.c,v 1.1 2006/08/22 21:35:13 wolti Exp $
 */

/* ----------------------- System includes ----------------------------------*/
#include "mbed.h"                   // Cam

/* ----------------------- Platform includes --------------------------------*/
#include "port.h"

/* ----------------------- Modbus includes ----------------------------------*/
#include "mb.h"
#include "mbport.h"


/* ----------------------- static functions ---------------------------------*/
static void prvvUARTTxReadyISR( void );
static void prvvUARTRxISR( void );


/* ----------------------- System Variables ---------------------------------*/
Serial ser3(PB_10, PC_5); //serial3
extern Serial pc;
static uint8_t grx_buf=0;

/* ----------------------- Start implementation -----------------------------*/
void
vMBPortSerialEnable( BOOL xRxEnable, BOOL xTxEnable )
{
    /* If xRXEnable enable serial receive interrupts. If xTxENable enable
     * transmitter empty interrupts.
     */
   

	//stanley
	ENTER_CRITICAL_SECTION( );
	

	ser3.attach(NULL); //close all
	
	if(xRxEnable)
		ser3.attach(&prvvUARTRxISR,Serial::RxIrq);
	
	if(xTxEnable)
	{
		ser3.attach(&prvvUARTTxReadyISR,Serial::TxIrq);
		while(!ser3.writeable());
		prvvUARTTxReadyISR();
	}		
	EXIT_CRITICAL_SECTION( );

	//if(xTxEnable)
		//Φbo]wser3.write(tx_buf,TX_BUFF_LENGTH,serialTxCBEvent,SERIAL_EVENT_TX_COMPLETE);

	//else
	//{
	//	ser3.attach(NULL,Serial::RxIrq);  //stanley  the test result find that this may disable RxIrq and TxIrq so have to enable TxIrq
	//	ser3.attach(&prvvUARTTxReadyISR,Serial::TxIrq);  
	//}
}

BOOL
xMBPortSerialInit( UCHAR ucPORT, ULONG ulBaudRate, UCHAR ucDataBits, eMBParity eParity )
{
   
	ser3.baud(ulBaudRate); //stanley
	

	return TRUE;
}

BOOL
xMBPortSerialPutByte( CHAR ucByte )
{
    /* Put a byte in the UARTs transmit buffer. This function is called
     * by the protocol stack if pxMBFrameCBTransmitterEmpty( ) has been
     * called. */

	//stanley
	ser3.putc( ucByte);

    return TRUE;
}

BOOL
xMBPortSerialGetByte( CHAR * pucByte )
{
    /* Return the byte in the UARTs receive buffer. This function is called
     * by the protocol stack after pxMBFrameCBByteReceived( ) has been called.
     */
	
	*pucByte = grx_buf;//stanley

	

    return TRUE;
}

/* Create an interrupt handler for the transmit buffer empty interrupt
 * (or an equivalent) for your target processor. This function should then
 * call pxMBFrameCBTransmitterEmpty( ) which tells the protocol stack that
 * a new character can be sent. The protocol stack will then call 
 * xMBPortSerialPutByte( ) to send the character.
 */
static void prvvUARTTxReadyISR( void )
{
    pxMBFrameCBTransmitterEmpty();
}

/* Create an interrupt handler for the receive interrupt for your target
 * processor. This function should then call pxMBFrameCBByteReceived( ). The
 * protocol stack will then call xMBPortSerialGetByte( ) to retrieve the
 * character.
 */
static void prvvUARTRxISR( void )
{
	if(ser3.readable())	//stanlely RX ISR must contain getc
		grx_buf=ser3.getc();

    pxMBFrameCBByteReceived();
}


