#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include <cstdlib>

#define OFF 0
#define ON 1

Serial pc(USBTX, USBRX);

PwmOut rled(PTE29);
PwmOut gled(PTD5);

MMA8451Q acc(PTE25, PTE24,0x1d<<1);
MAG3110 mag(PTE25, PTE24);
AnalogIn lightSensor(PTE22);
TSISensor tsi;
AnalogIn sinwave(PTB1);

int MAG_STATUS = OFF;
int ACCL_STATUS = OFF;
int LIGHT_STATUS = OFF;
int TOUCH_STATUS = OFF;
int SIN_STATUS = OFF;

Timer timer_mag;
Timer timer_acc;
Timer timer_light;
Timer timer_touch;
Timer timer_sin;

int count_mag = 32767;
int count_acc = 32767;
int count_light = 32767;
int count_touch = 32767;
int count_sin = 32767;

int START = OFF;

void send4bytes(char label,void* x){
    char *p = (char *)x;
    pc.putc(label);
    pc.putc(*p);
    pc.putc(*(p+1));
    pc.putc(*(p+2));
    pc.putc(*(p+3));
    }
void calXY() //magnetometer calibration: finding max and min of X, Y axis
{
    int tempXmax, tempXmin, tempYmax, tempYmin, newX, newY;

    rled = ON;

    printf("Waiting for initial press\n");
    // Wait for slider to be pressed
    while( tsi.readDistance() == 0 ) {
        rled = ON;
        wait(0.2);
        rled = OFF;
        wait(0.2);
    }

    printf("Waiting for release\n");

    // Wait for release
    while( tsi.readDistance() != 0 ) {
        rled = OFF;
        wait(0.2);
        rled = ON;
        wait(0.2);
    }
    rled = OFF;
    wait(0.5);

    printf("Rotate\n");

    tempXmax = tempXmin = mag.readVal(MAG_OUT_X_MSB);
    tempYmax = tempYmin = mag.readVal(MAG_OUT_Y_MSB);

    while(tsi.readDistance() == 0) {
        gled = ON;
        wait(0.1);
        gled = OFF;
        wait(0.1);
        newX = mag.readVal(MAG_OUT_X_MSB);
        newY = mag.readVal(MAG_OUT_Y_MSB);
        if (newX > tempXmax) tempXmax = newX;
        if (newX < tempXmin) tempXmin = newX;
        if (newY > tempYmax) tempYmax = newY;
        if (newY < tempYmin) tempYmin = newY;
    }
   
    mag.setCalibration( tempXmin, tempXmax, tempYmin, tempYmax );

    // Wait for release
    while( tsi.readDistance() != 0 ) {
        gled = OFF;
        wait(0.2);
        gled = ON;
        wait(0.2);
    }
    gled = OFF;
    wait(1.0);
}
void mag_send(){
    int temp_x = 0, temp_y = 0, temp_z = 0;
    float temp_h = mag.getHeading();
    mag.getValues(&temp_x, &temp_y, &temp_z);
    __disable_irq();
    send4bytes(0x00,&temp_x);
    send4bytes(0x01,&temp_y);
    send4bytes(0x02,&temp_z);
    send4bytes(0x03,&temp_h);
    __enable_irq();
}
void accl_send(){
    float temp_x = acc.getAccX();
    float temp_y = acc.getAccY();
    float temp_z = acc.getAccZ();
    __disable_irq();
    send4bytes(0x04,&temp_x);
    send4bytes(0x05,&temp_y);
    send4bytes(0x06,&temp_z);
    __enable_irq();
}

void light_send(){
    float temp_x = lightSensor;
    __disable_irq();
    send4bytes(0x07,&temp_x);
    __enable_irq();
}
 void touch_send(){
    float temp_x = tsi.readPercentage();;
    __disable_irq();
    send4bytes(0x08,&temp_x);
    __enable_irq();
}
void sin_send(){
    float temp_x = sinwave.read();;
    __disable_irq();
    send4bytes(0x09,&temp_x);
    __enable_irq();
}

void configure(){
    rled = OFF;
    // stop all the sensors
    MAG_STATUS = OFF;
    timer_mag.stop();
    ACCL_STATUS = OFF;   
    timer_acc.stop();
    LIGHT_STATUS = OFF;
    timer_light.stop();
    TOUCH_STATUS = OFF;
    timer_touch.stop();
    SIN_STATUS = OFF;
    timer_sin.stop();            
    
    char command = pc.getc();
    if (command != 0xEE)
        return;
    command = pc.getc();
    float sr;
    char temp[4];
    while(command != 0xEE){
        if (command == 0x00){ // MAG on
            MAG_STATUS = ON;
            temp[0] = pc.getc();
            temp[1] = pc.getc();
            temp[2] = pc.getc();
            temp[3] = pc.getc();
            sr = *(float*)temp;
            count_mag =(int) 1/sr *1000;
            timer_mag.reset();
        }
        if (command == 0x01){ // ACC on
            ACCL_STATUS = ON;
            temp[0] = pc.getc();
            temp[1] = pc.getc();
            temp[2] = pc.getc();
            temp[3] = pc.getc();
            sr = *(float*)temp;
            count_acc =(int) 1/sr *1000; 
            timer_acc.reset();                           
        }                     
        if (command == 0x02){ // LIGHT on
            LIGHT_STATUS = ON;
            temp[0] = pc.getc();
            temp[1] = pc.getc();
            temp[2] = pc.getc();
            temp[3] = pc.getc();
            sr = *(float*)temp;
            count_light =(int) 1/sr *1000;  
            timer_light.reset();                          
        }
        if (command == 0x03){ // TOUCH on
            TOUCH_STATUS = ON;
            temp[0] = pc.getc();
            temp[1] = pc.getc();
            temp[2] = pc.getc();
            temp[3] = pc.getc();
            sr = *(float*)temp;
            count_touch =(int) 1/sr *1000;
            timer_touch.reset();                          
        }
        if (command == 0x04){ // SIN on
            SIN_STATUS = ON;
            temp[0] = pc.getc();
            temp[1] = pc.getc();
            temp[2] = pc.getc();
            temp[3] = pc.getc();
            sr = *(float*)temp;
            count_sin =(int) 1/sr *1000;
            timer_sin.reset();                           
        }
        command = pc.getc();
    }
    rled = ON;     
    START = ON;
            
}

int main(){
    calXY();
    pc.attach(&configure);
    while(START == OFF){
        pc.putc(0xFF);    
    }
    pc.putc(0xFE);
    
        
    timer_mag.start();
    timer_acc.start();
    timer_light.start();
    timer_touch.start();
    timer_sin.start();
    while(1) {
        if (MAG_STATUS == ON){
            if (timer_mag.read_ms()>count_mag){
                   mag_send(); 
                   timer_mag.reset();
            }
        }
        if (ACCL_STATUS == ON){
            if (timer_acc.read_ms()>count_acc){
                   accl_send(); 
                   timer_acc.reset();
            }        
        }
        if (LIGHT_STATUS == ON){
            if (timer_light.read_ms()>count_light){
                   light_send(); 
                   timer_light.reset();
            }        
        }
        if (TOUCH_STATUS == ON){
            if (timer_touch.read_ms()>count_touch){
                   touch_send(); 
                   timer_touch.reset();
            }        
        }  
        if (SIN_STATUS == ON){
            if (timer_sin.read_ms()>count_sin){
                   sin_send(); 
                   timer_sin.reset();
            }        
        }           
    }
}