#include "mbed.h"
#include "KS0108.h" 
#include "MMA8451Q.h"
 
#include "SystemFont5x7.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1) 
#define carWidth 6
#define carLength 12
#define obstackleWidth 10
  
KS0108 display(PTC16, PTC17, PTA16, PTD6, PTC13, PTC12, PTC11, PTC10, PTC6, PTC5, PTC4, PTC3, PTC0, PTC7);

DigitalOut K(PTD7);

int carPositionX = 0;
int carPositionY = 0;
int obstacklePosX = 0;
int obstacklePosY = 0;
int startFlag = 0;
int obstackleFlag = 0;

void initRoad()
{
    display.Line(0,0,127,0, BLACK);
    display.Line(0,1,127,1, BLACK);
    display.Line(0,62,127,62, BLACK);
    display.Line(0,63,127,63, BLACK);
}

void initCar()
{
    display.FullRectangle(0,29,11,34, BLACK);
    carPositionX = 0;
    carPositionY = 29;
}

void moveCar(int flag)
{
    int speed = 4;
    switch(flag)
    {
        case 1:
        display.FullRectangle(carPositionX,carPositionY,carPositionX+11,carPositionY+5, WHITE);
        carPositionY = carPositionY+speed;
        display.FullRectangle(carPositionX,carPositionY,carPositionX+11,carPositionY+5, BLACK);
        break;
        case 2:
        display.FullRectangle(carPositionX,carPositionY,carPositionX+11,carPositionY+5, WHITE);
        carPositionY = carPositionY-speed;
        display.FullRectangle(carPositionX,carPositionY,carPositionX+11,carPositionY+5, BLACK);
        break;
        case 3:
        display.FullRectangle(carPositionX,carPositionY,carPositionX+11,carPositionY+5, WHITE);
        carPositionX = carPositionX+speed;
        display.FullRectangle(carPositionX,carPositionY,carPositionX+11,carPositionY+5, BLACK);
        break;
        case 4:
        display.FullRectangle(carPositionX,carPositionY,carPositionX+11,carPositionY+5, WHITE);
        carPositionX = carPositionX-speed;
        display.FullRectangle(carPositionX,carPositionY,carPositionX+11,carPositionY+5, BLACK);
        break;
    }
}

void checkColision()
{
    if((carPositionY<obstacklePosY)&&(carPositionX+12>obstacklePosX)||(carPositionY>obstacklePosY+10)&&(carPositionX+12>obstacklePosX))
    {
        startFlag = 3;    
    }
}

void initObstackle()
{
    display.FullRectangle(120,3,127,27, BLACK);
    display.FullRectangle(120,37,127,60, BLACK);
    obstacklePosX = 120;
    obstacklePosY = 27;
    obstackleFlag = 1;
}

void moveObstackle()
{
    int speed = 3;
    display.FullRectangle(obstacklePosX,3,obstacklePosX+8,27, WHITE);
    display.FullRectangle(obstacklePosX,37,obstacklePosX+8,60, WHITE);
    obstacklePosX = obstacklePosX-speed;
    if(obstacklePosX != 0)
    {
        display.FullRectangle(obstacklePosX,3,obstacklePosX+8,27, BLACK);
        display.FullRectangle(obstacklePosX,37,obstacklePosX+8,60, BLACK);
    }
    else
    {
        obstackleFlag = 0;
    }
}

void drawCar(int positionX, int positionY)
{
    display.RoundRectangle(positionX,positionY,64,28,12,BLACK);
    display.RoundRectangle(positionX+35,positionY+3,9,22,3,BLACK);
    display.RoundRectangle(positionX+16,positionY+3,6,22,2,BLACK);  
    display.Line(positionX+18,positionY+3,positionX+37,positionY+3, BLACK);
    display.Line(positionX+18,positionY+25,positionX+37,positionY+25, BLACK);
    display.FullRectangle(positionX-1,positionY+2,positionX+5,positionY+26, WHITE);
    display.EmptyRectangle(positionX-1,positionY+2,positionX+5,positionY+26, BLACK);  
    display.FullRectangle(positionX+7,positionY+8,positionX+14,positionY+12, BLACK);
    display.FullRectangle(positionX+7,positionY+16,positionX+14,positionY+20, BLACK);
    display.FullRectangle(positionX+24,positionY+8,positionX+33,positionY+12, BLACK);
    display.FullRectangle(positionX+24,positionY+16,positionX+33,positionY+20, BLACK); 
    display.FullRectangle(positionX+46,positionY+8,positionX+63,positionY+12, BLACK);
    display.FullRectangle(positionX+46,positionY+16,positionX+63,positionY+20, BLACK);    
}

void InitScreen()
{
    int count = 0;
    int distance = 0;
    int dimensionX = 127;
    int dimensionY = 63;

    display.ClearScreen();
    display.SelectFont(System5x7,BLACK,ReadData); 
    display.GotoXY(0,0);
    display.GotoXY(22,32);
    display.PrintString("RedOut PRESENTS");
    wait(2);
    display.ClearScreen();
    display.GotoXY(0,0);
    display.GotoXY(52,32);
    display.PrintString("GAME");
    
    for(count = 0;count<12;count++)
    {
        distance = count*2;
            
        display.RoundRectangle(distance,distance,dimensionX,dimensionY,3,BLACK);
        dimensionX = dimensionX - 4;
        dimensionY = dimensionY - 4;
    }
    wait(2);
    display.ClearScreen();
    drawCar(32,13);
    wait_ms(500);
    display.GotoXY(0,0);
    display.GotoXY(45,0);
    display.PrintString("DRIVING");
    wait_ms(800);
    display.GotoXY(0,0);
    display.GotoXY(18,48);
    display.PrintString("MOVE TO CONTINUE");
}

int main() 
{
    float moveX = 0;
    float moveY = 0;
    wait_ms(2000);
    K = 0;
    InitScreen();
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED_RED);
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);
 
    while(1) 
    {
        moveX = acc.getAccX();
        moveY = acc.getAccY();
        
        if(((moveX>0.5)||(moveY>0.5))&&(startFlag==0))
        {
            display.ClearScreen();
            display.GotoXY(0,0);
            display.GotoXY(22,16);
            display.PrintString("ON YOUR SEATS");
            wait(1);
            display.GotoXY(0,0);
            display.GotoXY(22,32);
            display.PrintString("DRIVE STARTING");
            wait(1);
            display.ClearScreen();
            initRoad();
            initCar();
            initObstackle();
            startFlag = 1;
        }
        
        if(startFlag == 1)
        {
            checkColision();
            if(obstackleFlag == 1)
            {
                moveObstackle();
            }
            if(obstackleFlag == 0)
            {
                initObstackle();
            }

            display.GotoXY(0,0);
            if(moveY<(-0.2))
            {
                if(carPositionY < 51)
                {
                    moveCar(1);
                }
            }
            if(moveY>0.2)
            {
                if(carPositionY > 6)
                {
                    moveCar(2);
                }
            }
            if(moveX>0.2)
            {
                if(carPositionX < (127-carLength))
                {
                    moveCar(3);
                }
            }
            if(moveX<(-0.2))
            {
                if(carPositionX > 0)
                {
                    moveCar(4);
                }
            }
        }
        
        if(startFlag==3)
        {
            display.ClearScreen();
            display.GotoXY(0,0);
            display.GotoXY(22,32);
            display.PrintString("GAME OVER");
            wait(10);
            startFlag = 0;
            InitScreen();
            
        }
        rled = 1.0 - abs(acc.getAccX());
        gled = 1.0 - abs(acc.getAccY());
        bled = 1.0 - abs(acc.getAccZ());    
    }
}
