#ifndef ROBOT_DEFINITION_H
#define ROBOT_DEFINITION_H

enum sequence_number {
    STOP_STATUS,
    INITIAL_STATUS,
    MANUAL_STATUS,
    ZERO_POINT_TURN,
    OPPOSITE_PHASE_RIGHT_TURN,
    RIGHT_SOFT_TURN,
    RIGHT_SOFT_TURN_BACK,
    OPPOSITE_PHASE_LEFT_TURN,
    LEFT_SOFT_TURN,
    LEFT_SOFT_TURN_BACK,
    RIGHT90_TURN,
    LEFT90_TURN,
    MODULE_FRONT,
    MODULE_BACK,
    ROBOT_CW_TURN,
    ROBOT_CCW_TURN
};

enum ControlNumber {
    PS3MODE,
    GUIMODE
};

enum Duty {
    CW95_DUTY       = 0xF8,
    CW80_DUTY       = 0xE4,
    CW70_DUTY       = 0xD7,
    CW60_DUTY       = 0xCA,
    CW50_DUTY       = 0xBE,
    CW40_DUTY       = 0xB3,
    CW30_DUTY       = 0xA6,
    CW20_DUTY       = 0x99,
    CW10_DUTY       = 0x8C,
    BREAK_DUTY      = 0x7F,
    CCW10_DUTY      = 0x72,
    CCW20_DUTY      = 0x65,
    CCW30_DUTY      = 0x58,
    CCW40_DUTY      = 0x4B,
    CCW50_DUTY      = 0x3F,
    CCW60_DUTY      = 0x32,
    CCW70_DUTY      = 0x26,
    CCW80_DUTY      = 0x19,
    CCW95_DUTY      = 0x07,
    ADJUST_DUTY     = 0x03
};
#endif