#ifndef TRACKED_VEHICLE_H
#define TRACKED_VEHICLE_H

#include "mbed.h"

class TrackedVehicle
{
private:
    enum MsgData {
        STATUS = 0,
        NUM,
        DUTY,
        PULSE_HIGH_BYTE,
        PULSE_LOW_BYTE,
        EMPTY1,
        EMPTY2,
        EMPTY3
    };
    enum sequence_number {
        STOP_STATUS,
        INITIAL_STATUS,
        MANUAL_STATUS,
        ZERO_POINT_TURN,
        OPPOSITE_PHASE_RIGHT_TURN,
        RIGHT_SOFT_TURN,
        RIGHT_SOFT_TURN_BACK,
        OPPOSITE_PHASE_LEFT_TURN,
        LEFT_SOFT_TURN,
        LEFT_SOFT_TURN_BACK,
        RIGHT90_TURN,
        LEFT90_TURN,
        MODULE_FRONT,
        MODULE_BACK,
        ROBOT_CW_TURN,
        ROBOT_CCW_TURN
    };
    short ModuleStatus;
    char CWDuty;
    char CCWDuty;
    char RightData[8];
    char LeftData[8];
    uint16_t RevolutionPulse;
    uint16_t EncoderPulse;
    uint16_t TargetPulse;
    uint16_t MinTargetPulse;
    uint16_t MaxTargetPulse;
    const uint16_t RightID;
    const uint16_t LeftID;
    float TargetAngle;
    CANMessage RightMsg;
    CANMessage LeftMsg;

public:
    enum MD_DUTY {
        CW95_DUTY       = 0xF8,
        CW80_DUTY       = 0xE4,
        CW70_DUTY       = 0xD7,
        CW60_DUTY       = 0xCA,
        CW50_DUTY       = 0xBE,
        CW40_DUTY       = 0xB3,
        CW30_DUTY       = 0xA6,
        CW20_DUTY       = 0x99,
        CW10_DUTY       = 0x8C,
        BREAK_DUTY      = 0x7F,
        CCW10_DUTY      = 0x72,
        CCW20_DUTY      = 0x65,
        CCW30_DUTY      = 0x58,
        CCW40_DUTY      = 0x4B,
        CCW50_DUTY      = 0x3F,
        CCW60_DUTY      = 0x32,
        CCW70_DUTY      = 0x26,
        CCW80_DUTY      = 0x19,
        CCW95_DUTY      = 0x07,
        ADJUST_DUTY     = 0x03
    };
    TrackedVehicle(uint16_t rightID, uint16_t leftID);
    void Stop_Robot(void);
    void Convert_PS3toMsg(short status, bool r, bool l, int8_t joystick);
    void Control_Angle(void);
    void Control_Turn(short status);
    void Control_Robot_Turn(short status, short robot_status);
    void Set_EncoderPulse(uint16_t pulse);
    void Set_TargetPulse(uint16_t pulse);
    void Set_TargetAngle(float angle);
    uint16_t Get_ModulePulse(void);
    float Get_ModuleAngle(void);
    short Get_ControlStatus(void);
    CANMessage* Get_RightMsg(void);
    CANMessage* Get_LeftMsg(void);
};

#endif