#include "mbed.h"

PwmOut Apwm(A5);
DigitalOut SD(A1);
DigitalOut myled(LED1);
DigitalIn Slide1(D12);
DigitalIn Slide2(D11);
DigitalIn Slide3(D10);
AnalogIn Vres(A0);

Serial pc(USBTX,USBRX);

int main()
{
    SD=1;
    Apwm.period_us(50);
    Slide1.mode(PullUp);
    Slide2.mode(PullUp);
    Slide3.mode(PullUp);
    pc.printf("Start\n");
    while(1) {
        for(float i=0.5; i<0.95; i+=0.01) {
            Apwm = i;
            wait_ms(50);
        }
        wait(3);
        for(float i=0.95; i>0.5; i-=0.01) {
            Apwm=i;
            wait_ms(50);
        }
        wait(3);
        pc.printf("Vres:%f{V]",Vres.read()*3.3);

        if(Slide1) pc.printf("Slide1:ON,");
        else pc.printf("Slide1:OFF,");

        if(Slide2) pc.printf("Slide2:ON,");
        else pc.printf("Slid2:OFF,");

        if(Slide3) pc.printf("Slide3:ON\n");
        else pc.printf("Slide3:OFF\n");

        myled = !myled;
    }
}
