#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include <string>

// OLEDとの通信に使用するI2Cオブジェクトを生成
I2C i2c(PB_7,PB_6);

// OLED制御クラスのインスタンス化
uint8_t i2cAddress = SSD_I2C_ADDRESS;
int rawHeight = 32;
int rawWidth = 128;
Adafruit_SSD1306_I2c oled(i2c, D10, i2cAddress);
Serial pc(USBTX,USBRX);//pcに表示させるための設定

DigitalIn  Slides[]  = {
    DigitalIn( D1 ),
    DigitalIn( D0 ),
    DigitalIn( D3 ),
    DigitalIn( D6 )
};

DigitalIn  Tacts[]  = {
    DigitalIn( D8 ),
    DigitalIn( D9 ),
    DigitalIn( D11 ),
    DigitalIn( D12 )
};

DigitalOut  leds[]  = {
    DigitalOut( A3 ),
    DigitalOut( A0 ),
    DigitalOut( D13 ),
    DigitalOut( A2 )
};

void print(std::string str);

char* line[]= {
    "Hello",
    "Good"
};

int main(void)
{
    char* a[]= {"HELLO"};
    char* b[]= {" WORLD"};
    char* c[]= {"\n"};
    char but=0x00;
    for(int i=0; i<4; i++) {
        Slides[i].mode(PullUp);
        Tacts[i].mode(PullUp);
        leds[i] = 1;
    }
//    float num1 = 1.1;
//    char str[20];
//    char* ptr[1];
//    sprintf(str, "%.9g", num1);
//    ptr[1] = (char*)str;
    while(1) {
        char data=0x01;
        for(int i=0; i<4; i++) {
            if ( Slides[i]  == 0 )
                but |= data;
            data<<=1;
        }
        for(int i=0; i<4; i++) {
            if ( Tacts[i]  == 0 )
                but |= data;
            data<<=1;
        }
        print(* a);
        print(* b);
        print(* c);
        pc.printf("but:0x%x\n",but);
        oled.clearDisplay();
        oled.setTextCursor(0,0);
        but=0x00;
        wait_ms(1);
    }
}

void print(std::string str)
{
    for(size_t i=0; i<str.size() ; i++) {
        oled._putc(str[i]);
    }
    // 表示を更新
    oled.display();
}