#include "mbed.h"
#include "MPU6050.h"
#include <string>

#define NUM 10

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
MPU6050 mpu;

int16_t ax, ay, az;
int16_t gx, gy, gz;
int sum_ax,sum_ay,sum_az;
int sum_gx,sum_gy,sum_gz;

int main()
{
    pc.printf("\033[2J");
    pc.printf("MPU6050 test\n\n");
    pc.printf("MPU6050 initialize \n");

    mpu.initialize();
    pc.printf("MPU6050 testConnection \n");

    bool mpu6050TestResult = mpu.testConnection();
    if(mpu6050TestResult) {
        pc.printf("MPU6050 test passed \n");
    } else {
        pc.printf("MPU6050 test failed \n");
    }
    pc.printf("\033[2J");
    while(1) {
//        mpu.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);
//        pc.printf("fa,%d:fg,%d",mpu.getFullScaleAccelRange(),mpu.getFullScaleGyroRange());
        //writing current accelerometer and gyro position

        for(int i=0; i < NUM; i++) {
            mpu.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);
            sum_ax += ax;
            sum_ay += ay;
            sum_az += az;

            sum_gx += gx;
            sum_gy += gy;
            sum_gz += gz;
        }
        pc.printf("\033[1;1HACCEL_x:%11fm/s^2",float(sum_ax)/(2048*NUM));
        pc.printf("\033[1;1HACCEL_x:%11fm/s^2",float(sum_ax)/(2048*NUM));
        pc.printf("\033[2;1HACCEL_y:%11fm/s^2",float(sum_ay)/(2048*NUM));
        pc.printf("\033[3;1HACCEL_z:%11fm/s^2",float(sum_az)/(2048*NUM));

        pc.printf("\033[5;1HGYRO_x:%12frad/s",float(sum_gx)/(16.4*NUM));
        pc.printf("\033[6;1HGYRO_y:%12frad/s",float(sum_gy)/(16.4*NUM));
        pc.printf("\033[7;1HGYRO_z:%12frad/s",float(sum_gz)/(16.4*NUM));

        sum_ax = 0;
        sum_ay = 0;
        sum_az = 0;

        sum_gx = 0;
        sum_gy = 0;
        sum_gz = 0;
    }
}
