/** NucleoF446re CAN1,CAN2 TEST CODE **/
/** 2019/11/27 Coding by Nagito Sukegawa **/
/** 2019/11/28 Add can2Rcv Function **/
/** 参考元 福島B Coding by YutaTogashi,@nitfc_togatogah URL:https://os.mbed.com/users/YutaTogashi/code/robocon2019_AutoRobot_mbed_testVer/ **/

#include "mbed.h"

void can1Trans(void);
void can2Rcv(void);
char counter[8] = {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07};
char RcvData[8];
Ticker ticker;
DigitalOut myled(LED1);
CAN can1(PB_8, PB_9,500000);    //データ吐く方//D15,D14
CAN can2(PB_5, PB_6,500000);    //データ受ける方//D4,D10
Serial pc(USBTX,NC,115200);
CANMessage msg1(0x456,counter,8,CANData,CANStandard);
CANMessage msg2(0x539,CANStandard);


int main()
{
    ticker.attach(&can1Trans, 0.05);
    can2.attach(&can2Rcv,CAN::RxIrq);
    pc.printf("\033[2J");
    while(1) {
//        pc.printf("TEST_CAN\n");
        wait(0.01);
    }
}


/** CAN1送信関数 **/
void can1Trans(void)
{
    if(counter[0] % 0x10 == 0) {
        msg1.id = 0x456;
        for(uint8_t i=0; i<8; i++) {
            msg1.data[i] = counter[i]++;
        }
    } else {
        msg1.id = 0x500;
        for(uint8_t i=0; i<8; i++) {
            msg1.data[i] = counter[i]++;
        }
    }
    if(can1.write(msg1)) {
        myled = !myled;
        pc.printf("\033[1;1HCAN1 TRANSID: 0x%x", msg1.id);
        pc.printf("\033[2;1HCAN1 DATA[0]: 0x%x", msg1.data[0]);
        pc.printf("\033[3;1HCAN1 DATA[1]: 0x%x", msg1.data[1]);
        pc.printf("\033[4;1HCAN1 DATA[2]: 0x%x", msg1.data[2]);
        pc.printf("\033[5;1HCAN1 DATA[3]: 0x%x", msg1.data[3]);
        pc.printf("\033[6;1HCAN1 DATA[4]: 0x%x", msg1.data[4]);
        pc.printf("\033[7;1HCAN1 DATA[5]: 0x%x", msg1.data[5]);
        pc.printf("\033[8;1HCAN1 DATA[6]: 0x%x", msg1.data[6]);
        pc.printf("\033[9;1HCAN1 DATA[7]: 0x%x", msg1.data[7]);
    }
    if(counter[0] >= 0xF0)
        pc.printf("\033[2J");
}

/** CAN2受信関数 **/
void can2Rcv(void)
{
    can2.read(msg2);
    pc.printf("\033[1;25HCAN2 RCVID: 0x%x\n", msg2.id);
    if(msg2.id == 0x539) {
        for(uint8_t i=0; i<8; i++) {
            RcvData[i] = msg2.data[i];
        }
        pc.printf("\033[2;25HCAN2 DATA[0]: 0x%x", RcvData[0]);
        pc.printf("\033[3;25HCAN2 DATA[0]: 0x%x", RcvData[1]);
        pc.printf("\033[4;25HCAN2 DATA[0]: 0x%x", RcvData[2]);
        pc.printf("\033[5;25HCAN2 DATA[0]: 0x%x", RcvData[3]);
        pc.printf("\033[6;25HCAN2 DATA[0]: 0x%x", RcvData[4]);
        pc.printf("\033[7;25HCAN2 DATA[0]: 0x%x", RcvData[5]);
        pc.printf("\033[8;25HCAN2 DATA[0]: 0x%x", RcvData[6]);
        pc.printf("\033[9;25HCAN2 DATA[0]: 0x%x", RcvData[7]);
        myled = !myled;
    }
}