#include <mbed.h>
int PT = 0;
int OLD_PT = 0;
char counter[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
char RcvData[8];

void CAN1_Trans(void);
void CAN2_Rcv(void);
void CHECK_PT(void);
void PT0(void);//ﾋｺｳｼﾞｮｰ
void PT1(void);//DJ
void PT2(void);//ﾜｯｶｲｯﾃﾓﾄﾞｯﾃ
void PT3(void);//ﾌﾞﾂｶｯﾁｬｳ
void PT4(void);//ｷﾞｬｸﾋｺｳｼﾞｮｰ
void PT5(void);//ﾄｹｲ
void PT6(void);//ﾊﾝﾄｹｲ
void PT7(void);
void PT8(void);
void PT9(void);


DigitalOut GLS[] = {
    DigitalOut(PC_3),
    DigitalOut(PC_2),
    DigitalOut(PC_13),
    DigitalOut(PB_7),
    DigitalOut(PA_15),
    DigitalOut(PC_12),
    DigitalOut(PC_11),
    DigitalOut(PC_10)
};

DigitalOut YLS[] = {
    DigitalOut(PC_4),
    DigitalOut(PA_10),
    DigitalOut(PB_3),
    DigitalOut(PB_4),
    DigitalOut(PB_10),
    DigitalOut(PA_8),
    DigitalOut(PA_9),
    DigitalOut(PC_7)
};

DigitalOut RLS[] = {
    DigitalOut(PA_12),
    DigitalOut(PA_11),
    DigitalOut(PB_12),
    DigitalOut(PB_2),
    DigitalOut(PB_1),
    DigitalOut(PB_15),
    DigitalOut(PB_14),
    DigitalOut(PB_13)
};

DigitalIn SW1(PC_6);
DigitalIn SW2(PC_5);

Ticker ticker;
Serial pc(USBTX,NC,115200);
CAN can1(PB_8, PB_9,500000);
CAN can2(PB_5, PB_6,500000);
CANMessage msg1(0x114,counter,8,CANData,CANStandard);
CANMessage msg2(0x114,CANStandard);

int main(void)
{
    SW1.mode(PullUp);
    SW2.mode(PullUp);
    ticker.attach(&CAN1_Trans, 0.1);
    can2.attach(&CAN2_Rcv,CAN::RxIrq);
    pc.printf("\033[2J");
    while(1) {
    }
}

void CAN1_Trans(void)
{
    msg1.id = 0x114;
    if(SW1 == 1 && SW2 == 1) {
        for(uint8_t i=0; i<8; i++) {
            msg1.data[i] = 0x00;
        }
    } else if(SW1 == 0 && SW2 == 0) {
        for(uint8_t i=0; i<8; i++) {
            msg1.data[i] = 0x33;
        }
    } else if(SW1 == 0) {
        for(uint8_t i=0; i<8; i++) {
            msg1.data[i] = 0x11;
        }
    } else if(SW2 == 0) {
        for(uint8_t i=0; i<8; i++) {
            msg1.data[i] = 0x22;
        }
    }
    if(can1.write(msg1)) {
        pc.printf("\033[1;1HCAN1 TRANSID: 0x%x", msg1.id);
        pc.printf("\033[2;1HCAN1 DATA[0]: 0x%x", msg1.data[0]);
        pc.printf("\033[3;1HCAN1 DATA[1]: 0x%x", msg1.data[1]);
        pc.printf("\033[4;1HCAN1 DATA[2]: 0x%x", msg1.data[2]);
        pc.printf("\033[5;1HCAN1 DATA[3]: 0x%x", msg1.data[3]);
        pc.printf("\033[6;1HCAN1 DATA[4]: 0x%x", msg1.data[4]);
        pc.printf("\033[7;1HCAN1 DATA[5]: 0x%x", msg1.data[5]);
        pc.printf("\033[8;1HCAN1 DATA[6]: 0x%x", msg1.data[6]);
        pc.printf("\033[9;1HCAN1 DATA[7]: 0x%x", msg1.data[7]);
    }
}

void CAN2_Rcv(void)
{
    can2.read(msg2);
    pc.printf("\033[1;25HCAN2 RCVID: 0x%x\n", msg2.id);
    if(msg2.id == 0x114) {
        for(uint8_t i=0; i<8; i++) {
            RcvData[i] = msg2.data[i];
        }
        if(RcvData[0] == 0x00) {
            PT = 0;
            CHECK_PT();
            PT0();
        } else if(RcvData[0] == 0x33) {
            PT = 3;
            CHECK_PT();
            PT4();
        } else if(RcvData[0] == 0x11) {
            PT = 1;
            CHECK_PT();
            PT1();
        } else if(RcvData[0] == 0x22) {
            PT = 2;
            CHECK_PT();
            PT2();
        }
        OLD_PT = PT;
        pc.printf("\033[2;25HCAN2 DATA[0]: 0x%x", RcvData[0]);
        pc.printf("\033[3;25HCAN2 DATA[0]: 0x%x", RcvData[1]);
        pc.printf("\033[4;25HCAN2 DATA[0]: 0x%x", RcvData[2]);
        pc.printf("\033[5;25HCAN2 DATA[0]: 0x%x", RcvData[3]);
        pc.printf("\033[6;25HCAN2 DATA[0]: 0x%x", RcvData[4]);
        pc.printf("\033[7;25HCAN2 DATA[0]: 0x%x", RcvData[5]);
        pc.printf("\033[8;25HCAN2 DATA[0]: 0x%x", RcvData[6]);
        pc.printf("\033[9;25HCAN2 DATA[0]: 0x%x", RcvData[7]);
    }
}

void CHECK_PT(void)
{
    if(OLD_PT != PT) {
        for(int i = 0; i<8; i++) {
            GLS[i] = 0;
            YLS[i] = 0;
            RLS[i] = 0;
        }
        pc.printf("\033[2J");
    }
}

void PT0(void)//ﾋｺｳｼﾞｮｰ
{
    for(int i = 0; i<8; i++) {
        GLS[i] = !GLS[i];
        YLS[i] = !YLS[i];
        RLS[i] = !RLS[i];
        wait(0.03);
    }
}

void PT1(void)//DJ
{
    for(int i = 0; i < 8; i++) {
        GLS[i] = 1;
        YLS[i] = 1;
        RLS[i] = 1;
        wait(0.03);
    }
    for(int i = 7; i >= 0; i--) {
        GLS[i] = 0;
        YLS[i] = 0;
        RLS[i] = 0;
        wait(0.03);
    }
}

void PT2(void)//ﾜｯｶｲｯﾃﾓﾄﾞｯﾃ
{
    for(int i = 7; i >= 0; i--) {
        GLS[i] = 1;
        wait(0.03);
    }
    for(int i = 7; i >= 0; i--) {
        YLS[i] = 1;
        wait(0.03);
    }
    for(int i = 7; i >= 0; i--) {
        RLS[i] = 1;
        wait(0.03);
    }

    for(int i = 0; i < 8; i++) {
        RLS[i] = 0;
        wait(0.03);
    }

    for(int i = 0; i < 8; i++) {
        YLS[i] = 0;
        wait(0.03);
    }
    for(int i = 0; i < 8; i++) {
        GLS[i] = 0;
        wait(0.03);
    }
}

void PT3(void)//ﾌﾞﾂｶｯﾁｬｳ
{
    for(int i = 7; i >= 0; i--) {
        GLS[i] = 1;
        RLS[7-i]  = 1;
        wait(0.03);
    }
    for(int i = 0; i < 4; i++) {
        YLS[i] = 1;
        YLS[7-i] = 1;
        wait(0.03);
    }
    for(int i = 3; i >= 0; i--) {
        YLS[i] = 0;
        YLS[7-i] = 0;
        wait(0.03);
    }
    for(int i = 7; i >= 0; i--) {
        GLS[7-i] = 0;
        RLS[i] = 0;
        wait(0.03);
    }
}

void PT4(void)//ｷﾞｬｸﾋｺｳｼﾞｮｰ
{
    for(int i = 7; i >= 0; i--) {
        GLS[i] = !GLS[i];
        YLS[i] = !YLS[i];
        RLS[i] = !RLS[i];
        wait(0.03);
    }
}

void PT5(void)//ﾄｹｲ
{
    for(int i = 0; i<8; i++) {
        GLS[i] = 1;
        wait(0.03);
    }
    for(int i = 0; i<8; i++) {
        GLS[i] = 0;
    }
}

void PT6(void)//ﾊﾝﾄｹｲ
{

}