// uLCD-144-G2 demo program for uLCD-4GL LCD driver library
//
#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include <mpr121.h>
#include "uLCD_4DGL.h"

#define BURGER_HEIGHT 15
#define BURGER_WIDTH 30

#define CENTER 50
#define _ 0x000000 //BLACK
#define X 0x32CD32 //GREEN
#define Y 0XFF6347 //TOMATO
#define M 0XFFDB58 // CHEESE
#define Z 0XE6AF5D // BUN
#define Q 0X654321 //MEAT

uLCD_4DGL uLCD(p13,p14,p11); // serial tx, serial rx, reset pin;

// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);

// Setup the Serial to the PC for debugging
Serial pc(USBTX, USBRX);

RawSerial  dev(p9,p10);

// Setup the i2c bus on pins 28 and 27
I2C i2c(p28, p27);

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

AnalogOut DACout(p18);
wave_player waver(&DACout);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card

Thread thread2;
Thread thread3;

void draw();
void initalize();
bool results();

int TOPBUN[BURGER_HEIGHT * BURGER_WIDTH] = {
    _,_,_,_,_,_,_,_,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,_,_,_,_,_,
    _,_,_,_,_,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,_,_,_,
    _,_,_,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,_,_,
    _,_,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,_,
    _,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,
    _,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
};

int LETTUCE[BURGER_HEIGHT * BURGER_WIDTH] = {
    _,_,_,_,_,_,X,X,X,_,_,_,X,X,X,_,_,_,X,X,X,_,X,X,_,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,X,_,X,X,X,X,X,_,X,X,X,X,_,X,X,X,_,_,_,_,_,
    _,_,_,_,X,X,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,_,
    _,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,
    _,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,
    _,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,
    X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,
    _,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,
    _,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,
    _,_,_,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_,_,_,
    _,_,_,_,_,_,X,X,X,X,_,X,X,X,X,X,_,X,X,X,X,_,X,X,X,_,_,_,_,_,
    _,_,_,_,_,_,X,X,X,_,_,_,X,X,X,_,_,_,X,X,X,_,X,X,_,_,_,_,_,_,
};

int TOMATO[BURGER_HEIGHT * BURGER_WIDTH] = {
    _,_,_,_,_,_,_,_,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,_,_,_,_,_,
    _,_,_,_,_,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,_,_,_,
    _,_,_,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,_,_,
    _,_,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,_,
    _,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,
    _,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,
    _,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,
    _,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,
    _,_,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,_,
    _,_,_,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,_,_,
    _,_,_,_,_,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,_,_,_,
    _,_,_,_,_,_,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,Y,_,_,_,_,_,_,_,_,
};

int CHEESE[BURGER_HEIGHT * BURGER_WIDTH] = {
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,
    M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,
    M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,
    M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,
    M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,
    M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,
    M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
};

int MEAT[BURGER_HEIGHT * BURGER_WIDTH] = {
    _,_,_,_,_,_,_,_,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,_,_,_,_,_,
    _,_,_,_,_,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,_,_,_,
    _,_,_,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,_,_,
    _,_,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,_,
    _,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,
    _,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,
    _,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,
    _,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,
    _,_,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,_,
    _,_,_,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,_,_,
    _,_,_,_,_,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,_,_,_,
    _,_,_,_,_,_,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,Q,_,_,_,_,_,_,_,_,
};

int BOTTOMBUN[BURGER_HEIGHT * BURGER_WIDTH] = {
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,
    _,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,
    _,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,
    _,_,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,_,
    _,_,_,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,_,_,
    _,_,_,_,_,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,_,_,_,
    _,_,_,_,_,_,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,Z,_,_,_,_,_,_,_,_,
};
int value;
bool pressed = false;
// Key hit/release interrupt routine
void fallInterrupt()
{
    value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    if (value <= 16) pressed = true;
}

void sound_thread()
{
    FILE *wave_file;
    wave_file=fopen("/sd/wavfiles/food.wav","r");
    if (wave_file)pc.printf("it worked");
    else pc.printf("it failed");
    waver.play(wave_file);
    fclose(wave_file);
}
bool burger_result=true;
void result_sound()
{
    FILE *wave_file;
    if(burger_result) {
        wave_file=fopen("/sd/wavfiles/boing.wav","r");
        waver.play(wave_file);
    } else {
        wave_file =fopen("/sd/wavfiles/BUZZER.wav","r");
        waver.play(wave_file);
    }
    fclose(wave_file);
}

bool playing;
int count;
char* order[4] = {"", "", "", ""};
char* made[4] = {"", "", "", ""};
int CurrentPosition = 110;
int main()
{
    srand (time(NULL));
    wait(.01);
    dev.baud(9600);

    initalize();

    uLCD.BLIT(CENTER, CurrentPosition, BURGER_WIDTH, BURGER_HEIGHT, BOTTOMBUN);
    CurrentPosition-=7;

    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);

    playing = true;
    count = 0;
    while(playing) {
        thread2.start(sound_thread);
        if (pressed) {
            draw();
            wait(.01);
            count++;
        }
    }
    Thread::wait(2000);
    burger_result = results();
    thread3.start(result_sound);
}


char* ingredients[] = {"Lettuce\n","Tomato\n","Cheese\n","Meat\n"}; //list of ingredients
void initalize()
{
    int num_ingredients = 4;
    order[0] = ingredients[rand() % num_ingredients];
    order[1] = ingredients[rand() % num_ingredients];
    order[2] = ingredients[rand() % num_ingredients];
    order[3] = ingredients[rand() % num_ingredients];

    dev.puts("Order:\n");
    dev.puts(order[0]);
    dev.puts(order[1]);
    dev.puts(order[2]);
    dev.puts(order[3]);
    wait(5);
    dev.puts("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nStart your order\n");
}


bool results()
{
    bool val;
    uLCD.cls();
    if ((!strcmp(order[0],made[0])) && (!strcmp(order[1],made[1])) && (!strcmp(order[2],made[2])) && (!strcmp(order[3],made[3]))) {
        uLCD.printf("YOU WON\n");
        val = true;
    } else {
        uLCD.printf("YOU LOST\n");
        val = false;
    }
    uLCD.printf("order:\n %s %s %s %s\n\r", order[0], order[1], order[2], order[3]);
    uLCD.printf("made:\n %s %s %s %s\n\r", made[0], made[1], made[2], made[3]);

    return val;
}

void draw()
{
    if (((value>>0)&0x01)==1) {
        uLCD.BLIT(CENTER, CurrentPosition, BURGER_WIDTH, BURGER_HEIGHT, LETTUCE);
        made[count] = "Lettuce\n";
    } else if (((value>>1)&0x01)==1) {
        uLCD.BLIT(CENTER, CurrentPosition, BURGER_WIDTH, BURGER_HEIGHT, TOMATO);
        made[count] = "Tomato\n";
        CurrentPosition-=7;
    } else if (((value>>2)&0x01)==1) {
        uLCD.BLIT(CENTER, CurrentPosition, BURGER_WIDTH, BURGER_HEIGHT, CHEESE);
        made[count] = "Cheese\n";
    } else if (((value>>3)&0x01)==1) {
        uLCD.BLIT(CENTER, CurrentPosition, BURGER_WIDTH, BURGER_HEIGHT, MEAT);
        made[count] = "Meat\n";
    } else if (((value>>4)&0x01)==1) {
        uLCD.BLIT(CENTER, CurrentPosition, BURGER_WIDTH, BURGER_HEIGHT, TOPBUN);
        playing = false;
    }
    CurrentPosition-=7;
    pressed = false;
}