#ifndef PCF2119_16X2_LCD_H
#define PCF2119_16X2_LCD_H

#include "mbed.h"


#define ASCII_OFFSET 0x80

// Define LCD parameters
#define LCD_I2C_ADR          0x76  // address + W

#define FUNCTION_SET 0x34 //Function_set - 2 lines x 16, 1:18 Multiplex drive mode, 8 bits, basic instr. set
#define DISPLAY_CTL 0x0C // Cursor off / Blink off / Character blink off

#define INSTRUCTION_CTRL_BYTE 0x00
#define DATA_CTRL_BYTE 0x40

#define VLCD_MULTIPLIER 0x90
#define VLCD_CONTRAST 0xA8
#define ENTRY_MODE 0x06 // DDRAM or CGRAM address increments by 1, cursor moves to the right / Display does not shift
#define CURSOR_DISLPAY_SHIFT 0x04 // cursor moves to the right (no display shift)
#define ICON_CTRL 0x08 // direct mode off / icon blink disabled / character mode full display

#define CLEAR_DISPLAY 0x01

#define BLANK_CHAR ' '

class PC2119_16X2_LCD {
public:
    PC2119_16X2_LCD(PinName p_sda, PinName p_scl, PinName p_reset);
    PC2119_16X2_LCD(I2C& p_i2c, PinName p_reset);
    void Init();
    void flip_display();
    void unflip_display();
    void clear_display();
    void clear_line(char row);
    void write_xy(char ddram_byte, char row, char column, bool raw = false);
    void write(char *b);
    void printf(const char * format, ... );
protected:    

private:
    I2C _i2c;
    DigitalOut _reset;
    
    char ascii_to_lcd(char ch);

};

#endif